/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.network.client;

import com.razz.decocraft.common.containers.DecobenchScreenHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CDecobenchSelectTab(String tabName, float scrollOffset) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CDecobenchSelectTab> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"decocraft", (String)"decobench_select_tab"));
    public static final StreamCodec<ByteBuf, CDecobenchSelectTab> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CDecobenchSelectTab::tabName, (StreamCodec)ByteBufCodecs.FLOAT, CDecobenchSelectTab::scrollOffset, CDecobenchSelectTab::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CDecobenchSelectTab payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            AbstractContainerMenu screenHandler = player.containerMenu;
            if (!(screenHandler instanceof DecobenchScreenHandler)) {
                return;
            }
            DecobenchScreenHandler decobench = (DecobenchScreenHandler)screenHandler;
            decobench.selectTab(payload.tabName, payload.scrollOffset);
        });
    }
}

