/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.razz.decocraft.DecoException;
import com.razz.decocraft.client.render.AnimatedModelRenderer;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.blocks.DecoAnimatedBlock;
import com.razz.decocraft.common.tileentities.AnimatedTileEntity;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class AnimatedRenderer
implements class_827<AnimatedTileEntity> {
    private static final String ROOT = "ROOT";
    private static Map<String, class_630> CACHE = Collections.synchronizedMap(new HashMap());
    private static Map<String, class_1058> SPRITE_CACHE = Collections.synchronizedMap(new HashMap());

    public AnimatedRenderer(class_5614.class_5615 context) {
    }

    public void render(AnimatedTileEntity tileEntity, float partialTick, class_4587 matrixStackIn, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        tileEntity.updateTimer();
        if (!tileEntity.method_11002()) {
            return;
        }
        class_2680 blockstate = tileEntity.method_10997().method_8320(tileEntity.method_11016());
        if (!blockstate.method_28498((class_2769)class_2741.field_12481)) {
            return;
        }
        class_2350 facing = (class_2350)blockstate.method_11654((class_2769)class_2741.field_12481);
        JsonContainer.Entry meta = null;
        BBModel bbModel = null;
        if (blockstate.method_26204() instanceof DecoAnimatedBlock) {
            DecoAnimatedBlock animatedBlock = (DecoAnimatedBlock)blockstate.method_26204();
            meta = animatedBlock.meta;
            bbModel = animatedBlock.model;
        }
        if (meta == null || bbModel == null) {
            return;
        }
        AnimatedModelRenderer model = this.parseModel(meta, bbModel, tileEntity);
        class_2960 textureId = class_2960.method_60655((String)"decocraft", (String)("block/" + meta.material));
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        class_1092 bakedModelManager = client.method_1554();
        if (bakedModelManager == null) {
            return;
        }
        class_1059 atlas = bakedModelManager.method_24153(class_1059.field_5275);
        if (atlas == null) {
            return;
        }
        String spriteKey = meta.material;
        class_1058 sprite = SPRITE_CACHE.get(spriteKey);
        if (sprite == null) {
            sprite = atlas.method_4608(textureId);
            SPRITE_CACHE.put(spriteKey, sprite);
        }
        class_1921 renderLayer = class_1921.method_23580((class_2960)class_1059.field_5275);
        class_4588 vertexUV = bufferIn.getBuffer(renderLayer);
        RenderSystem.enablePolygonOffset();
        RenderSystem.polygonOffset((float)-1.0f, (float)-1.0f);
        matrixStackIn.method_22903();
        matrixStackIn.method_22907(class_7833.field_40715.rotationDegrees(facing.method_10144()));
        matrixStackIn.method_22907(class_7833.field_40713.rotationDegrees(180.0f));
        matrixStackIn.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
        switch (facing) {
            case field_11043: {
                matrixStackIn.method_22904(0.5, 0.0, 0.5);
                break;
            }
            case field_11035: {
                matrixStackIn.method_22904(-0.5, 0.0, -0.5);
                break;
            }
            case field_11034: {
                matrixStackIn.method_22904(0.5, 0.0, -0.5);
                break;
            }
            case field_11039: {
                matrixStackIn.method_22904(-0.5, 0.0, 0.5);
                break;
            }
        }
        model.render(matrixStackIn, vertexUV, combinedLightIn, combinedOverlayIn, sprite);
        matrixStackIn.method_22909();
        RenderSystem.disablePolygonOffset();
    }

    private AnimatedModelRenderer parseModel(JsonContainer.Entry meta, BBModel bbmodel, AnimatedTileEntity tileEntity) {
        class_2960 modelLocation = class_2960.method_60655((String)"decocraft", (String)("models/block/" + meta.model + ".bbmodel"));
        BlockbenchLoader.BlockbenchSetting settings = new BlockbenchLoader.BlockbenchSetting(modelLocation, meta.scale > 0.0f ? meta.scale : 1.0f, false, false, meta.material != null ? meta.material : "default");
        AnimatedModelRenderer model = new AnimatedModelRenderer(bbmodel.resolution.width, bbmodel.resolution.height, null, ROOT, settings);
        Map<UUID, Map<BBModelParts.Channel, float[]>> keyframes = tileEntity.getKeyframes();
        this.parseOutliners(bbmodel.resolution.width, bbmodel.resolution.height, new BBModelParts.ElementBase(), bbmodel.outliner, bbmodel.uuidMap, model, ROOT, keyframes, settings);
        return model;
    }

    private void parseOutliners(int width, int height, BBModelParts.ElementBase topNode, List<BBModelParts.OutlinerNode> nodes, Map<UUID, BBModelParts.ElementBase> uuidMap, AnimatedModelRenderer topRenderer, String path, Map<UUID, Map<BBModelParts.Channel, float[]>> keyframes, BlockbenchLoader.BlockbenchSetting settings) {
        for (BBModelParts.OutlinerNode outNode : nodes) {
            BBModelParts.ElementBase elementBase;
            if (outNode instanceof BBModelParts.OutlinerGroup) {
                elementBase = (BBModelParts.OutlinerGroup)outNode;
            } else if (outNode instanceof BBModelParts.OutlinerCube) {
                elementBase = uuidMap.get(((BBModelParts.OutlinerCube)outNode).uuid);
            } else {
                throw new DecoException("Error processing the outliners");
            }
            String name = path + "/" + elementBase.name;
            AnimatedModelRenderer modelRenderer = new AnimatedModelRenderer(width, height, Objects.equals(elementBase.type, "cube") && elementBase instanceof BBModelParts.Element ? (BBModelParts.Element)elementBase : null, name, settings);
            float[] animRot = new float[]{0.0f, 0.0f, 0.0f};
            float[] animPos = new float[]{0.0f, 0.0f, 0.0f};
            if (keyframes.get(elementBase.uuid) != null) {
                if (keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.ROTATION) != null) {
                    animRot = keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.ROTATION);
                }
                if (keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.POSITION) != null) {
                    animPos = keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.POSITION);
                }
            }
            modelRenderer.setPivot(elementBase.origin.x - topNode.origin.x - animPos[0], elementBase.origin.y - topNode.origin.y + animPos[1], elementBase.origin.z - topNode.origin.z + animPos[2]);
            modelRenderer.pitch = elementBase.rotation.x - animRot[0];
            modelRenderer.yaw = elementBase.rotation.y - animRot[1];
            modelRenderer.roll = elementBase.rotation.z + animRot[2];
            topRenderer.addChild(modelRenderer);
            if (Objects.equals(elementBase.type, "cube") && elementBase instanceof BBModelParts.Element) {
                BBModelParts.Element element = (BBModelParts.Element)elementBase;
                if (!(outNode instanceof BBModelParts.OutlinerCube)) continue;
                modelRenderer.addCuboid(element.from.x - element.origin.x, element.from.y - element.origin.y, element.from.z - element.origin.z, element.to.x - element.from.x, element.to.y - element.from.y, element.to.z - element.from.z);
                continue;
            }
            BBModelParts.ElementBase group = elementBase;
            this.parseOutliners(width, height, elementBase, group.children, uuidMap, modelRenderer, name, keyframes, settings);
        }
    }

    private void parseElements(int width, int height, List<BBModelParts.Element> elements, AnimatedModelRenderer topRenderer, String path, Map<UUID, Map<BBModelParts.Channel, float[]>> keyframes, BlockbenchLoader.BlockbenchSetting settings) {
        elements.sort((a, b) -> {
            int posCompare = Float.compare(a.from.x + a.from.y + a.from.z, b.from.x + b.from.y + b.from.z);
            if (posCompare != 0) {
                return posCompare;
            }
            return a.uuid.compareTo(b.uuid);
        });
        for (BBModelParts.Element element : elements) {
            String name = path + "/" + element.name;
            AnimatedModelRenderer modelRenderer = new AnimatedModelRenderer(width, height, element, name, settings);
            float[] animRot = new float[]{0.0f, 0.0f, 0.0f};
            float[] animPos = new float[]{0.0f, 0.0f, 0.0f};
            if (keyframes.get(element.uuid) != null) {
                if (keyframes.get(element.uuid).get((Object)BBModelParts.Channel.ROTATION) != null) {
                    animRot = keyframes.get(element.uuid).get((Object)BBModelParts.Channel.ROTATION);
                }
                if (keyframes.get(element.uuid).get((Object)BBModelParts.Channel.POSITION) != null) {
                    animPos = keyframes.get(element.uuid).get((Object)BBModelParts.Channel.POSITION);
                }
            }
            modelRenderer.setPivot(element.origin.x - animPos[0], element.origin.y + animPos[1], element.origin.z + animPos[2]);
            modelRenderer.pitch = element.rotation.x - animRot[0];
            modelRenderer.yaw = element.rotation.y - animRot[1];
            modelRenderer.roll = element.rotation.z + animRot[2];
            topRenderer.addChild(modelRenderer);
            modelRenderer.addCuboid(element.from.x - element.origin.x, element.from.y - element.origin.y, element.from.z - element.origin.z, element.to.x - element.from.x, element.to.y - element.from.y, element.to.z - element.from.z);
        }
    }
}

