/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client;

import com.razz.decocraft.client.particles.ParticleFallingLiquid;
import com.razz.decocraft.client.particles.ParticleFlame;
import com.razz.decocraft.client.particles.ParticleSmoke;
import com.razz.decocraft.client.render.AnimatedRenderer;
import com.razz.decocraft.client.render.DecoRender;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleParticleTypes;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import com.razz.decocraft.models.obj.OBJLoader;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="decocraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        RenderType cutoutCulling = RenderType.func_228643_e_();
        RenderType cutoutNoCulling = DecoRender.decoCutout();
        RenderType translucentCulling = RenderType.func_228645_f_();
        RenderType translucentNoCulling = DecoRender.decoTranslucent();
        for (Map.Entry<String, RegistryObject<Block>> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            DecocraftBlock block = (DecocraftBlock)entry.getValue().get();
            if (!Objects.equals(block.meta.type, "animated")) {
                RenderType renderer = !block.meta.transparency ? cutoutCulling : translucentCulling;
                RenderTypeLookup.setRenderLayer((Block)block, (RenderType)renderer);
                continue;
            }
            RenderTypeLookup.setRenderLayer((Block)block, (RenderType)ForgeRenderTypes.ITEM_LAYERED_CUTOUT.get());
        }
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModuleTileEntities.ANIMATED_TE.get()), AnimatedRenderer::new);
    }

    @SubscribeEvent
    static void modelRegistry(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("decocraft", "bbmodel"), (IModelLoader)BlockbenchLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("decocraft", "objmodel"), (IModelLoader)OBJLoader.INSTANCE);
    }

    @SubscribeEvent
    static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModuleParticleTypes.SMOKE_NORMAL.get(), ParticleSmoke.FactoryNormal::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModuleParticleTypes.SMOKE_SMALL.get(), ParticleSmoke.FactorySmall::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModuleParticleTypes.FLAME_NORMAL.get(), ParticleFlame.FactoryNormal::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModuleParticleTypes.FLAME_SMALL.get(), ParticleFlame.FactorySmall::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModuleParticleTypes.FALLING_WATER.get(), ParticleFallingLiquid.FactoryWaterRandom::new);
    }
}

