/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.containers;

import com.razz.decocraft.common.ModuleContainers;
import com.razz.decocraft.common.ModuleItems;
import com.razz.decocraft.common.groups.GroupSelector;
import com.razz.decocraft.common.tileentities.DecobenchTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.NonNullList;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class DecobenchContainer
extends Container {
    public static final int ROWS = 4;
    public static final int COLUMNS = 7;
    public static final int CONTAINER_SLOT_ID = 11;
    private static final Inventory CONTAINER = new Inventory(28);
    private static final int FIRST_ROW = 37;
    private static final int FIRST_COLUMNS = 54;
    private static final int SPACING = 18;
    private static final int INVENTORY_X = 22;
    private static final int INVENTORY_Y = 147;
    public final NonNullList<ItemStack> items = NonNullList.func_191196_a();
    public final IWorldPosCallable access;
    public int[] colors = new int[3];
    public int[] rawMaterial = new int[1];
    public int[] crafting = new int[2];
    private DecobenchTileEntity decobenchTE;
    private World world;

    public DecobenchContainer(int containerId, PlayerInventory playerInventory) {
        this(containerId, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public DecobenchContainer(int containerId, PlayerInventory inventory, IWorldPosCallable access) {
        super((ContainerType)ModuleContainers.DECOBENCH.get(), containerId);
        int i;
        this.access = access;
        this.access.func_221486_a((world, pos) -> {
            this.decobenchTE = (DecobenchTileEntity)world.func_175625_s(pos);
            this.world = world;
        });
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventory, i, 22 + i * 18, 147));
        }
        this.func_75146_a(new Slot((IInventory)(this.decobenchTE == null ? new Inventory(1) : this.decobenchTE.getInput()), 0, 14, 16){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof DyeItem || stack.func_77973_b() == ModuleItems.RAW_MATERIAL.get();
            }
        });
        this.func_75146_a(new Slot((IInventory)(this.decobenchTE == null ? new Inventory(1) : this.decobenchTE.getResult()), 0, 175, 116){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }
        });
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.func_75146_a(new Slot((IInventory)CONTAINER, i * 7 + j, 54 + j * 18, 37 + i * 18){

                    public boolean func_82869_a(PlayerEntity pPlayer) {
                        return false;
                    }
                });
            }
        }
        this.getTabItems("all");
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.colors, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.colors, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.colors, (int)2));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.rawMaterial, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.crafting, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.crafting, (int)1));
        this.getTEData();
    }

    public void scrollTo(float pos) {
        int rowMax = (this.items.size() + 7 - 1) / 7 - 4;
        int posScrolled = (int)((double)(pos * (float)rowMax) + 0.5);
        if (posScrolled < 0) {
            posScrolled = 0;
        }
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 7; ++column) {
                int item = column + (row + posScrolled) * 7;
                if (item >= 0 && item < this.items.size()) {
                    CONTAINER.func_70299_a(column + row * 7, (ItemStack)this.items.get(item));
                    continue;
                }
                CONTAINER.func_70299_a(column + row * 7, ItemStack.field_190927_a);
            }
        }
        this.func_75142_b();
    }

    public boolean func_75145_c(PlayerEntity player) {
        return (Boolean)this.access.func_221485_a((world, pos) -> player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0, (Object)true);
    }

    private void getTEData() {
        if (this.world != null && !this.world.func_201670_d()) {
            this.colors[0] = this.decobenchTE.getColorRed();
            this.colors[1] = this.decobenchTE.getColorGreen();
            this.colors[2] = this.decobenchTE.getColorBlue();
            this.rawMaterial[0] = this.decobenchTE.getRawMaterial();
            this.crafting[0] = this.decobenchTE.getCraft();
            this.crafting[1] = this.decobenchTE.getCraftingTimer();
        }
    }

    public void getTabItems(String tabText) {
        this.items.clear();
        if (!GroupSelector.SELECT.containsKey(tabText)) {
            tabText = "all";
        }
        if (tabText.equals("all")) {
            for (ItemGroup tab : GroupSelector.SELECT.values()) {
                this.fillItemList(tab, this.items);
            }
        } else {
            this.fillItemList(GroupSelector.SELECT.get(tabText), this.items);
        }
        this.scrollTo(0.0f);
    }

    private void fillItemList(ItemGroup tab, NonNullList<ItemStack> pItems) {
        for (Item item : Registry.field_212630_s) {
            item.func_150895_a(tab, pItems);
        }
    }

    public void search(String s) {
        this.items.clear();
        String search = s.toLowerCase();
        for (ItemGroup tab : GroupSelector.SELECT.values()) {
            this.fillItemList(tab, this.items);
        }
        this.items.removeIf(stack -> !stack.func_77977_a().toLowerCase().contains(search));
        this.scrollTo(0.0f);
    }

    public void craft(int craft) {
        this.decobenchTE.setCraft(craft);
    }

    public boolean canScroll() {
        return this.items.size() > 28;
    }

    public void func_75142_b() {
        this.getTEData();
        super.func_75142_b();
    }

    public ItemStack func_184996_a(int pSlotId, int pButton, ClickType pClickType, PlayerEntity pPlayer) {
        ClickType type = pClickType == ClickType.QUICK_MOVE ? ClickType.PICKUP : pClickType;
        return this.func_241440_b_(pSlotId, pButton, type, pPlayer);
    }
}

