/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.DecoException;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.network.DecocraftPacketHandler;
import com.razz.decocraft.network.server.SUpdateAnimation;
import com.razz.decocraft.utils.DecoMath;
import com.razz.decocraft.utils.nbt.NBTMeta;
import com.razz.decocraft.utils.nbt.NBTModel;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnimatedTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final String NBT_ANIM_NAME = "animName";
    private static final Logger LOGGER = LogManager.getLogger();
    private JsonContainer.Entry meta;
    private BBModel model;
    private BBModelParts.Animation animation;
    private String animationName;
    private double timer = 0.0;
    private String sound = "";

    public AnimatedTileEntity(@Nullable JsonContainer.Entry meta, @Nullable BBModel model) {
        super((TileEntityType)ModuleTileEntities.ANIMATED_TE.get());
        this.meta = meta;
        this.model = model;
        if (this.meta != null) {
            this.setAnimationName(meta.default_animation);
        }
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        if (nbt.func_74764_b("meta")) {
            this.meta = NBTMeta.fromNBT(nbt.func_74775_l("meta"));
        }
        if (nbt.func_74764_b("model")) {
            this.model = NBTModel.fromNBT(nbt.func_74775_l("model"));
        }
        if (nbt.func_74764_b(NBT_ANIM_NAME)) {
            this.setAnimationName(nbt.func_74779_i(NBT_ANIM_NAME));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        this.saveNBTCustom(nbt);
        if (this.meta != null) {
            nbt.func_218657_a("meta", (INBT)NBTMeta.toNBT(this.meta));
        }
        if (this.model != null) {
            nbt.func_218657_a("model", (INBT)NBTModel.toNBT(this.model));
        }
        return super.func_189515_b(nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.saveNBTCustom(nbt);
        return nbt;
    }

    private void saveNBTCustom(CompoundNBT nbt) {
        if (this.animationName != null) {
            nbt.func_74778_a(NBT_ANIM_NAME, this.animationName);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 64.0;
    }

    public void func_73660_a() {
        if (EffectiveSide.get().isServer()) {
            this.timer += 0.05;
            if (this.animation != null && this.timer >= (double)this.animation.length) {
                this.timer = 0.0;
                BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                ((DecocraftBlock)state.func_177230_c()).onAnimationEnd(state, this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public void setAnimationName(String animName) {
        if (Objects.equals(animName, "any")) {
            animName = this.model.animationPerName.keySet().toArray(new String[0])[new Random().nextInt(this.model.animationPerName.size())];
        }
        if (Objects.equals(animName, "any_other")) {
            animName = this.animationName;
            while (Objects.equals(animName, this.animationName)) {
                animName = this.model.animationPerName.keySet().toArray(new String[0])[new Random().nextInt(this.model.animationPerName.size())];
            }
        }
        if (!Objects.equals(animName, this.animationName)) {
            this.timer = 0.0;
        }
        this.animationName = animName;
        this.func_70296_d();
        this.animation = this.model.animationPerName.get(animName);
        if (this.animation == null) {
            throw new DecoException(String.format("Animation %s cannot be found in model %s", animName, this.model));
        }
        if (EffectiveSide.get().isServer()) {
            DecocraftPacketHandler.HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SUpdateAnimation(this.func_174877_v(), animName));
        }
    }

    public double getTimer() {
        return this.timer;
    }

    public void addTimer(double timer) {
        this.timer += timer;
    }

    public Map<String, Map<BBModelParts.Channel, float[]>> getKeyframes() {
        HashMap<String, Map<BBModelParts.Channel, float[]>> results = new HashMap<String, Map<BBModelParts.Channel, float[]>>();
        if (this.animation == null || this.animation.length == 0.0f) {
            return results;
        }
        double timer = this.timer % (double)this.animation.length;
        for (Map.Entry<String, BBModelParts.Animator> animator : this.animation.animators.entrySet()) {
            String key = animator.getKey();
            List<BBModelParts.Keyframe> keyframes = animator.getValue().keyframes;
            results.put(key, new EnumMap(BBModelParts.Channel.class));
            for (BBModelParts.Channel channel : BBModelParts.Channel.values()) {
                BBModelParts.Keyframe lowKeyframe = keyframes.stream().filter(k -> k.channel == channel).filter(k -> (double)k.time < timer).max(Comparator.comparing(i -> Float.valueOf(i.time))).orElse(null);
                BBModelParts.Keyframe highKeyframe = keyframes.stream().filter(k -> k.channel == channel).filter(k -> (double)k.time >= timer).min(Comparator.comparing(i -> Float.valueOf(i.time))).orElse(null);
                if (lowKeyframe == null || highKeyframe == null) continue;
                BBModelParts.DataPoint low = lowKeyframe.data_points.get(0);
                BBModelParts.DataPoint high = highKeyframe.data_points.get(0);
                ((Map)results.get(key)).put(channel, new float[]{DecoMath.lerp(low.x, high.x, ((float)timer - lowKeyframe.time) / (highKeyframe.time - lowKeyframe.time)), DecoMath.lerp(low.y, high.y, ((float)timer - lowKeyframe.time) / (highKeyframe.time - lowKeyframe.time)), DecoMath.lerp(low.z, high.z, ((float)timer - lowKeyframe.time) / (highKeyframe.time - lowKeyframe.time))});
            }
        }
        return results;
    }
}

