/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.common.ModuleItems;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.items.DecoBlockItem;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public class DecobenchTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final float COLORS_MAX = 256.0f;
    public static final float RAW_MATERIAL_MAX = 128.0f;
    public static final float CRAFTING_TIME = 40.0f;
    private final Inventory result = new Inventory(1);
    private final Inventory input = new Inventory(1);
    private ItemStack pendingCrafting = ItemStack.field_190927_a;
    private ItemStack currentCrafting = ItemStack.field_190927_a;
    private int colorRed = 0;
    private int colorGreen = 0;
    private int colorBlue = 0;
    private int rawMaterial = 0;
    private int timer = 0;
    private int craft = 0;
    private int craftingTimer = 0;

    public DecobenchTileEntity() {
        super((TileEntityType)ModuleTileEntities.DECOBENCH_TE.get());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.func_201670_d()) {
            ++this.timer;
            if (this.timer % 10 == 0) {
                this.timer = 0;
                ItemStack inputStack = this.input.func_70301_a(0);
                if (inputStack.func_77973_b() instanceof DyeItem) {
                    Color color = Color.byName(((DyeItem)inputStack.func_77973_b()).func_195962_g().func_176762_d(), Color.BLACK);
                    if (color != Color.BLACK && (float)(this.colorRed + color.getRed()) <= 256.0f && (float)(this.colorGreen + color.getGreen()) <= 256.0f && (float)(this.colorBlue + color.getBlue()) <= 256.0f) {
                        inputStack.func_190920_e(inputStack.func_190916_E() - 1);
                        this.input.func_70299_a(0, inputStack);
                        this.colorRed += color.getRed();
                        this.colorGreen += color.getGreen();
                        this.colorBlue += color.getBlue();
                    }
                } else if (inputStack.func_77973_b() == ModuleItems.RAW_MATERIAL.get() && (float)(this.rawMaterial + 1) <= 128.0f) {
                    inputStack.func_190920_e(inputStack.func_190916_E() - 1);
                    this.input.func_70299_a(0, inputStack);
                    ++this.rawMaterial;
                }
            }
            if (this.currentCrafting == ItemStack.field_190927_a && this.pendingCrafting != ItemStack.field_190927_a) {
                this.currentCrafting = this.pendingCrafting;
            }
            if (this.craft == 1 && this.currentCrafting != ItemStack.field_190927_a && this.currentCrafting.func_77973_b() instanceof DecoBlockItem && this.result.func_233541_b_(this.currentCrafting) && ((DecoBlockItem)this.currentCrafting.func_77973_b()).getRed() <= this.getColorRed() && ((DecoBlockItem)this.currentCrafting.func_77973_b()).getGreen() <= this.getColorGreen() && ((DecoBlockItem)this.currentCrafting.func_77973_b()).getBlue() <= this.getColorBlue() && ((DecoBlockItem)this.currentCrafting.func_77973_b()).getMaterial() <= this.getRawMaterial() && ((DecoBlockItem)this.currentCrafting.func_77973_b()).getRed() >= 0 && ((DecoBlockItem)this.currentCrafting.func_77973_b()).getGreen() >= 0 && ((DecoBlockItem)this.currentCrafting.func_77973_b()).getBlue() >= 0) {
                ++this.craftingTimer;
                if ((float)this.craftingTimer >= 40.0f) {
                    this.colorRed -= ((DecoBlockItem)this.currentCrafting.func_77973_b()).getRed();
                    this.colorGreen -= ((DecoBlockItem)this.currentCrafting.func_77973_b()).getGreen();
                    this.colorBlue -= ((DecoBlockItem)this.currentCrafting.func_77973_b()).getBlue();
                    this.rawMaterial -= ((DecoBlockItem)this.currentCrafting.func_77973_b()).getMaterial();
                    this.craftingTimer = 0;
                    this.craft = 0;
                    this.result.func_174894_a(this.currentCrafting.func_77946_l());
                    this.currentCrafting = ItemStack.field_190927_a;
                }
            } else {
                this.currentCrafting = ItemStack.field_190927_a;
                this.craftingTimer = 0;
                this.craft = 0;
            }
        }
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.colorRed = nbt.func_74762_e("color_red");
        this.colorGreen = nbt.func_74762_e("color_green");
        this.colorBlue = nbt.func_74762_e("color_blue");
        this.rawMaterial = nbt.func_74762_e("raw_material");
        this.craft = nbt.func_74762_e("craft");
        this.craftingTimer = nbt.func_74762_e("crafting_timer");
        this.currentCrafting = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("current_crafting"));
        this.result.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("result")));
        this.input.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("input")));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        this.saveNBTCustom(nbt);
        return super.func_189515_b(nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.saveNBTCustom(nbt);
        return nbt;
    }

    private void saveNBTCustom(CompoundNBT nbt) {
        nbt.func_74768_a("color_red", this.colorRed);
        nbt.func_74768_a("color_green", this.colorGreen);
        nbt.func_74768_a("color_blue", this.colorBlue);
        nbt.func_74768_a("raw_material", this.rawMaterial);
        nbt.func_74768_a("craft", this.craft);
        nbt.func_74768_a("crafting_timer", this.craftingTimer);
        CompoundNBT currentCraftingNBT = new CompoundNBT();
        this.currentCrafting.func_77955_b(currentCraftingNBT);
        CompoundNBT resultNBT = new CompoundNBT();
        this.result.func_70301_a(0).func_77955_b(resultNBT);
        CompoundNBT inputNBT = new CompoundNBT();
        this.input.func_70301_a(0).func_77955_b(inputNBT);
        nbt.func_218657_a("current_crafting", (INBT)currentCraftingNBT);
        nbt.func_218657_a("result", (INBT)resultNBT);
        nbt.func_218657_a("input", (INBT)inputNBT);
    }

    public int getColorRed() {
        return this.colorRed;
    }

    public int getColorGreen() {
        return this.colorGreen;
    }

    public int getColorBlue() {
        return this.colorBlue;
    }

    public int getRawMaterial() {
        return this.rawMaterial;
    }

    public Inventory getInput() {
        return this.input;
    }

    public Inventory getResult() {
        return this.result;
    }

    public void setResult(ItemStack result) {
        this.result.func_70299_a(0, result);
    }

    public int getCraft() {
        return this.craft;
    }

    public void setCraft(int craft) {
        this.craft = craft;
    }

    public int getCraftingTimer() {
        return this.craftingTimer;
    }

    public void setPendingCrafting(ItemStack pendingCrafting) {
        this.pendingCrafting = pendingCrafting == null ? ItemStack.field_190927_a : pendingCrafting;
    }

    private static enum Color {
        WHITE(0, "white", 4, 4, 4),
        GRAY(7, "gray", 2, 2, 2),
        LIGHT_GRAY(8, "light_gray", 1, 1, 1),
        BLACK(15, "black", 0, 0, 0),
        ORANGE(1, "orange", 6, 3, 1),
        MAGENTA(2, "magenta", 6, 0, 6),
        LIGHT_BLUE(3, "light_blue", 1, 3, 6),
        YELLOW(4, "yellow", 6, 6, 0),
        LIME(5, "lime", 1, 6, 0),
        PINK(6, "pink", 6, 1, 3),
        CYAN(9, "cyan", 0, 6, 6),
        PURPLE(10, "purple", 3, 0, 3),
        BROWN(12, "brown", 1, 1, 0),
        BLUE(11, "blue", 0, 0, 12),
        GREEN(13, "green", 0, 12, 0),
        RED(14, "red", 12, 0, 0);

        private final int id;
        private final String name;
        private final int red;
        private final int green;
        private final int blue;

        private Color(int id, String name, int r, int g, int b) {
            this.id = id;
            this.name = name;
            this.red = r;
            this.green = g;
            this.blue = b;
        }

        public static Color byName(String name, Color fallback) {
            for (Color color : Color.values()) {
                if (!color.name.equals(name)) continue;
                return color;
            }
            return fallback;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }
    }
}

