/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.common.ModuleItems;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.items.DecoBlockItem;
import com.razz.mods.Mods;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class DecomposerTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final float CRAFTING_TIME = 40.0f;
    public static final ItemStack DIRT = new ItemStack((IItemProvider)Items.field_221582_j);
    public static final ItemStack COBBLESTONE = new ItemStack((IItemProvider)Items.field_221585_m);
    public static final ItemStack RAW_MATERIAL = new ItemStack((IItemProvider)ModuleItems.RAW_MATERIAL.get());
    public static final float FUEL_MAX = 16000.0f;
    private final Inventory input = new Inventory(1);
    private final Inventory result = new Inventory(1);
    private final Inventory fuel = new Inventory(1);
    private int currentFuel = 0;
    private long fuelTimer = 0L;
    private int craft = 0;
    private int craftingTimer = 0;

    public DecomposerTileEntity() {
        super((TileEntityType)ModuleTileEntities.DECOMPOSER_TE.get());
    }

    public void func_73660_a() {
        ++this.fuelTimer;
        if (!this.fuel.func_191420_l() && this.fuelTimer > 10L) {
            int burnTime = 0;
            if ("".equals("")) {
                burnTime = ForgeHooks.getBurnTime((ItemStack)this.fuel.func_70301_a(0), null);
            } else if (this.fuel.func_70301_a(0).func_77969_a(((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(""))).func_190903_i())) {
                burnTime = 1600;
            } else {
                return;
            }
            if ((float)(this.currentFuel + burnTime) <= 16000.0f || this.currentFuel == 0) {
                if (this.fuel.func_70301_a(0).hasContainerItem()) {
                    ItemStack container = this.fuel.func_70301_a(0).getContainerItem();
                    this.fuel.func_70299_a(0, container);
                } else {
                    this.fuel.func_70298_a(0, 1);
                }
                this.fuelTimer = 0L;
                this.currentFuel += burnTime;
            }
        }
        if (this.craft == 1 && this.result.func_233541_b_(RAW_MATERIAL) && this.input.func_70301_a(0) != ItemStack.field_190927_a) {
            Item item;
            boolean found = this.input.func_70301_a(0).func_77973_b() instanceof DecoBlockItem;
            if (!found) {
                for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                    item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.getKey()));
                    if (item == null) {
                        item = Items.field_190931_a;
                    }
                    try {
                        if (!this.input.func_70301_a(0).func_77969_a(item.func_190903_i()) && !this.input.func_70301_a(0).func_77973_b().func_206844_a((ITag)ItemTags.func_199901_a((String)entry.getKey())) || this.input.func_70301_a(0).func_190916_E() < entry.getValue()) continue;
                        found = true;
                        break;
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
            }
            if (!found) {
                return;
            }
            if (this.input.func_70301_a(0).func_77973_b() instanceof DecoBlockItem && ((DecoBlockItem)this.input.func_70301_a(0).func_77973_b()).getMaterial() + this.result.func_70301_a(0).func_190916_E() > RAW_MATERIAL.func_77976_d()) {
                return;
            }
            if (this.currentFuel > 0) {
                ++this.craftingTimer;
                if ((float)this.craftingTimer >= 40.0f) {
                    this.craftingTimer = 0;
                    if (this.input.func_70301_a(0).func_77973_b() instanceof DecoBlockItem) {
                        ItemStack stack = RAW_MATERIAL.func_77946_l();
                        stack.func_190920_e(((DecoBlockItem)this.input.func_70301_a(0).func_77973_b()).getMaterial());
                        this.input.func_70298_a(0, 1);
                        this.result.func_174894_a(stack);
                    } else {
                        for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.getKey()));
                            if (item == null) {
                                item = Items.field_190931_a;
                            }
                            try {
                                if (!this.input.func_70301_a(0).func_77969_a(item.func_190903_i()) && !this.input.func_70301_a(0).func_77973_b().func_206844_a((ITag)ItemTags.func_199901_a((String)entry.getKey()))) continue;
                                this.input.func_70298_a(0, entry.getValue().intValue());
                                this.result.func_174894_a(RAW_MATERIAL);
                                break;
                            }
                            catch (IllegalStateException illegalStateException) {
                            }
                        }
                    }
                }
            }
            this.currentFuel -= 10;
            this.currentFuel = MathHelper.func_76125_a((int)this.currentFuel, (int)0, (int)Integer.MAX_VALUE);
        } else {
            this.craftingTimer = 0;
            this.craft = 0;
        }
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.craft = nbt.func_74762_e("craft");
        this.craftingTimer = nbt.func_74762_e("crafting_timer");
        this.currentFuel = nbt.func_74762_e("current_fuel");
        this.result.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("result")));
        this.input.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("input")));
        this.fuel.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("fuel")));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        this.saveNBTCustom(nbt);
        return super.func_189515_b(nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.saveNBTCustom(nbt);
        return nbt;
    }

    private void saveNBTCustom(CompoundNBT nbt) {
        nbt.func_74768_a("craft", this.craft);
        nbt.func_74768_a("crafting_timer", this.craftingTimer);
        nbt.func_74768_a("current_fuel", this.currentFuel);
        CompoundNBT resultNBT = new CompoundNBT();
        this.result.func_70301_a(0).func_77955_b(resultNBT);
        CompoundNBT inputNBT = new CompoundNBT();
        this.input.func_70301_a(0).func_77955_b(inputNBT);
        CompoundNBT fuelNBT = new CompoundNBT();
        this.fuel.func_70301_a(0).func_77955_b(fuelNBT);
        nbt.func_218657_a("result", (INBT)resultNBT);
        nbt.func_218657_a("input", (INBT)inputNBT);
        nbt.func_218657_a("fuel", (INBT)fuelNBT);
    }

    public Inventory getInput() {
        return this.input;
    }

    public Inventory getResult() {
        return this.result;
    }

    public Inventory getFuel() {
        return this.fuel;
    }

    public int getCraft() {
        return this.craft;
    }

    public void setCraft(int craft) {
        this.craft = craft;
    }

    public int getCraftingTimer() {
        return this.craftingTimer;
    }

    public int getCurrentFuel() {
        return this.currentFuel;
    }
}

