/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.network.client;

import com.razz.decocraft.common.containers.DecobenchContainer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CDecobenchCraft {
    public final int craft;

    public CDecobenchCraft(int craft) {
        this.craft = craft;
    }

    public static CDecobenchCraft decoder(PacketBuffer buffer) {
        int craft = buffer.readInt();
        return new CDecobenchCraft(craft);
    }

    public void encoder(PacketBuffer buffer) {
        buffer.writeInt(this.craft);
    }

    public static class Handler {
        public static void handle(CDecobenchCraft message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Handler.handlePacket(message, ctx));
        }

        private static void handlePacket(CDecobenchCraft message, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayerEntity player = ctx.get().getSender();
            if (player == null) {
                ctx.get().setPacketHandled(true);
                return;
            }
            Container container = player.field_71070_bA;
            if (!(container instanceof DecobenchContainer)) {
                ctx.get().setPacketHandled(true);
                return;
            }
            DecobenchContainer decobench = (DecobenchContainer)container;
            decobench.craft(message.craft);
            ctx.get().setPacketHandled(true);
        }
    }
}

