/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.network.client;

import com.razz.decocraft.common.containers.DecobenchContainer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CDecobenchScroll {
    public final float scroll;

    public CDecobenchScroll(float scroll) {
        this.scroll = scroll;
    }

    public static CDecobenchScroll decoder(PacketBuffer buffer) {
        float scroll = buffer.readFloat();
        return new CDecobenchScroll(scroll);
    }

    public void encoder(PacketBuffer buffer) {
        buffer.writeFloat(this.scroll);
    }

    public static class Handler {
        public static void handle(CDecobenchScroll message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Handler.handlePacket(message, ctx));
        }

        private static void handlePacket(CDecobenchScroll message, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayerEntity player = ctx.get().getSender();
            if (player == null) {
                ctx.get().setPacketHandled(true);
                return;
            }
            Container container = player.field_71070_bA;
            if (!(container instanceof DecobenchContainer)) {
                ctx.get().setPacketHandled(true);
                return;
            }
            DecobenchContainer decobench = (DecobenchContainer)container;
            decobench.scrollTo(message.scroll);
            ctx.get().setPacketHandled(true);
        }
    }
}

