/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.network.client;

import com.razz.decocraft.common.containers.DecomposerContainer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CDecomposerCraft {
    public final int craft;

    public CDecomposerCraft(int craft) {
        this.craft = craft;
    }

    public static CDecomposerCraft decoder(PacketBuffer buffer) {
        int craft = buffer.readInt();
        return new CDecomposerCraft(craft);
    }

    public void encoder(PacketBuffer buffer) {
        buffer.writeInt(this.craft);
    }

    public static class Handler {
        public static void handle(CDecomposerCraft message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Handler.handlePacket(message, ctx));
        }

        private static void handlePacket(CDecomposerCraft message, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayerEntity player = ctx.get().getSender();
            if (player == null) {
                ctx.get().setPacketHandled(true);
                return;
            }
            Container container = player.field_71070_bA;
            if (!(container instanceof DecomposerContainer)) {
                ctx.get().setPacketHandled(true);
                return;
            }
            DecomposerContainer decomposer = (DecomposerContainer)container;
            decomposer.craft(message.craft);
            ctx.get().setPacketHandled(true);
        }
    }
}

