/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.razz.decocraft.DecoException;
import com.razz.decocraft.Decocraft;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelLoader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.ModList;

public class JsonParser {
    public static String[] parseFiles(String location) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        String[] strings = null;
        URL directory = Decocraft.class.getResource('/' + location);
        if (directory != null && "file".equals(directory.getProtocol())) {
            try (FileReader reader = new FileReader(directory.getFile());){
                strings = (String[])gson.fromJson((Reader)reader, String[].class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (directory != null && "modjar".equals(directory.getProtocol())) {
            String mod = ModList.get().getModFileById("decocraft").getFile().getFilePath().toString();
            try {
                ZipFile zipFile = new ZipFile(mod);
                ZipEntry zipEntry = zipFile.getEntry(location);
                strings = (String[])gson.fromJson((Reader)new InputStreamReader(zipFile.getInputStream(zipEntry)), String[].class);
                zipFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DecoException("Error! Problem reading doors.json!");
            }
        } else {
            throw new DecoException("Protocol unknown");
        }
        return strings;
    }

    public static JsonContainer parseDecocraft(String location) {
        JsonContainer models = null;
        URL directory = Decocraft.class.getResource('/' + location);
        if (directory != null && "file".equals(directory.getProtocol())) {
            models = new JsonContainer((String)directory.getFile()).entries;
        } else if (directory != null && "modjar".equals(directory.getProtocol())) {
            String mod = ModList.get().getModFileById("decocraft").getFile().getFilePath().toString();
            try {
                ZipFile zipFile = new ZipFile(mod);
                ZipEntry zipEntry = zipFile.getEntry(location);
                models = new JsonContainer((InputStream)zipFile.getInputStream((ZipEntry)zipEntry)).entries;
                zipFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DecoException("Error! Problem reading " + location);
            }
            if (models == null) {
                throw new DecoException("Error! The number of models is null!");
            }
        } else {
            throw new DecoException("Protocol unknown");
        }
        return models;
    }

    public static BBModel parseModel(String location, ZipFile zipfile) {
        BBModel model = null;
        if (zipfile == null) {
            URL directory = Decocraft.class.getResource('/' + location);
            model = new BBModelLoader().loadModel(directory.getFile());
        } else {
            try {
                ZipEntry zipEntry = zipfile.getEntry(location);
                model = new BBModelLoader().loadModel(zipfile.getInputStream(zipEntry));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (model == null) {
                throw new DecoException("Error finding the json. The JAR must contain the 'decocraft' word! | " + location);
            }
        }
        return model;
    }

    public static ZipFile openZip() {
        URL directory = Decocraft.class.getResource("");
        if (directory != null && "modjar".equals(directory.getProtocol())) {
            String mod = ModList.get().getModFileById("decocraft").getFile().getFilePath().toString();
            try {
                return new ZipFile(mod);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void closeZip(ZipFile zipFile) {
        URL directory = Decocraft.class.getResource("");
        if (directory != null && "modjar".equals(directory.getProtocol())) {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

