/*
 * Decompiled with CFR 0.152.
 */
package com.razz.essentialpartnermod;

import com.razz.essentialpartnermod.Draw;
import com.razz.essentialpartnermod.mc.Font;

public class Tooltip {
    public static void drawTooltip(Draw draw, String text, Position position, int parentX, int parentY, int parentWidth, int parentHeight) {
        int y;
        int x;
        String[] lines = text.split("\n");
        int maxWidth = 0;
        for (String line : lines) {
            maxWidth = Math.max(maxWidth, Font.getStringWidth(line));
        }
        int width = maxWidth + 8;
        int height = 10 * lines.length + 4;
        switch (position) {
            case ABOVE: {
                x = parentX + parentWidth / 2 - width / 2;
                y = parentY - height - 5;
                break;
            }
            case BELOW: {
                x = parentX + parentWidth / 2 - width / 2;
                y = parentY + parentHeight + 5;
                break;
            }
            case LEFT: {
                x = parentX - width - 5;
                y = parentY + parentHeight / 2 - height / 2;
                break;
            }
            case RIGHT: {
                x = parentX + parentWidth + 5;
                y = parentY + parentHeight / 2 - height / 2;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int centerX = x + width / 2;
        int centerY = y + height / 2;
        draw.rect(x - 1, y - 1, x + width + 1, y + height + 1, -16777216);
        draw.rect(x, y, x + width, y + height, -14474461);
        int textY = y;
        for (String line : lines) {
            int lineWidth = Font.getStringWidth(line);
            draw.string(line, centerX - lineWidth / 2, textY + 3, -1710619, -16777216);
            textY += 10;
        }
        block14: for (int i = 0; i <= 2; ++i) {
            switch (position) {
                case ABOVE: {
                    draw.rect(centerX - (2 - i) - 1, y + height + i + 1, centerX + (2 - i), y + height + i + 2, -16777216);
                    draw.rect(centerX - (2 - i) - 1, y + height + i, centerX + (2 - i), y + height + i + 1, -14474461);
                    continue block14;
                }
                case BELOW: {
                    draw.rect(centerX - (2 - i) - 1, y - i - 2, centerX + (2 - i), y - i - 1, -16777216);
                    draw.rect(centerX - (2 - i) - 1, y - i - 1, centerX + (2 - i), y - i, -14474461);
                    continue block14;
                }
                case LEFT: {
                    draw.rect(x + width + i + 1, centerY - (2 - i) - 1, x + width + i + 2, centerY + (2 - i), -16777216);
                    draw.rect(x + width + i, centerY - (2 - i) - 1, x + width + i + 1, centerY + (2 - i), -14474461);
                    continue block14;
                }
                case RIGHT: {
                    draw.rect(x - i - 2, centerY - (2 - i) - 1, x - i - 1, centerY + (2 - i), -16777216);
                    draw.rect(x - i - 1, centerY - (2 - i) - 1, x - i, centerY + (2 - i), -14474461);
                }
            }
        }
    }

    public static enum Position {
        ABOVE,
        BELOW,
        LEFT,
        RIGHT;

    }
}

