/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.render;

import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public class AnimatedModelRenderer {
    public final String name;
    private final BBModelParts.Element element;
    private final int textureWidth;
    private final int textureHeight;
    private final BlockbenchLoader.BlockbenchSetting settings;
    private boolean mirror;
    public float pitch;
    public float yaw;
    public float roll;
    public float pivotX;
    public float pivotY;
    public float pivotZ;
    private static final ThreadLocal<float[][]> VERTEX_POOL = ThreadLocal.withInitial(() -> new float[][]{new float[3], new float[3], new float[3], new float[3]});
    public boolean visible = true;
    private final List<AnimatedModelRenderer> children = new ArrayList<AnimatedModelRenderer>();
    private final class_630 modelPart;
    private final List<ModelBox> cubes = new ArrayList<ModelBox>();

    private static float[] getPooledVertex(int index) {
        return VERTEX_POOL.get()[index % 4];
    }

    public AnimatedModelRenderer(int width, int height, BBModelParts.Element element, String name, BlockbenchLoader.BlockbenchSetting settings) {
        this.textureWidth = width;
        this.textureHeight = height;
        this.element = element;
        this.name = name;
        this.settings = settings != null ? settings : AnimatedModelRenderer.createDefaultSettings();
        this.mirror = false;
        this.pitch = 0.0f;
        this.yaw = 0.0f;
        this.roll = 0.0f;
        this.pivotX = 0.0f;
        this.pivotY = 0.0f;
        this.pivotZ = 0.0f;
        this.modelPart = new class_630(Collections.emptyList(), Collections.emptyMap());
    }

    public AnimatedModelRenderer(int width, int height, BBModelParts.Element element, String name) {
        this(width, height, element, name, null);
    }

    private static BlockbenchLoader.BlockbenchSetting createDefaultSettings() {
        return new BlockbenchLoader.BlockbenchSetting(new class_2960("default", "default"), 1.0f, false, false, "default");
    }

    public class_630 addCuboid(float x, float y, float z, float dimX, float dimY, float dimZ) {
        this.addCuboid(x, y, z, dimX, dimY, dimZ, 0.0f, 0.0f, 0.0f, this.mirror);
        return this.modelPart;
    }

    public void addCuboid(float x, float y, float z, float dimX, float dimY, float dimZ, float growX, float growY, float growZ, boolean mirror) {
        if (this.element != null) {
            this.cubes.add(new ModelBox(x, y, z, dimX, dimY, dimZ, growX, growY, growZ, mirror, this.textureWidth, this.textureHeight, this.element, this.settings));
        }
    }

    public void addChild(AnimatedModelRenderer child) {
        this.children.add(child);
    }

    public void setPivot(float x, float y, float z) {
        this.pivotX = x;
        this.pivotY = y;
        this.pivotZ = z;
        this.modelPart.method_2851(x, y, z);
    }

    public void render(class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
        this.render(matrices, vertices, light, overlay);
    }

    public void render(class_4587 matrices, class_4588 vertices, int light, int overlay) {
        this.render(matrices, vertices, light, overlay, null);
    }

    public void render(class_4587 matrices, class_4588 vertices, int light, int overlay, class_1058 sprite) {
        if (this.visible) {
            matrices.method_22903();
            this.translateAndRotate(matrices);
            for (ModelBox cube : this.cubes) {
                cube.render(matrices, vertices, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, sprite);
            }
            for (AnimatedModelRenderer child : this.children) {
                child.render(matrices, vertices, light, overlay, sprite);
            }
            matrices.method_22909();
        }
    }

    private void renderCube(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha, class_1058 sprite) {
        float v2;
        float u2;
        float v1;
        float u1;
        if (this.element == null) {
            return;
        }
        float x = (this.element.from.x - this.element.origin.x) / 16.0f;
        float y = (this.element.from.y - this.element.origin.y) / 16.0f;
        float z = (this.element.from.z - this.element.origin.z) / 16.0f;
        float xMax = (this.element.to.x - this.element.origin.x) / 16.0f;
        float yMax = (this.element.to.y - this.element.origin.y) / 16.0f;
        float zMax = (this.element.to.z - this.element.origin.z) / 16.0f;
        BBModelParts.Face uvDown = this.element.faces.get(class_2350.field_11033);
        BBModelParts.Face uvUp = this.element.faces.get(class_2350.field_11036);
        BBModelParts.Face uvNorth = this.element.faces.get(class_2350.field_11043);
        BBModelParts.Face uvSouth = this.element.faces.get(class_2350.field_11035);
        BBModelParts.Face uvEast = this.element.faces.get(class_2350.field_11034);
        BBModelParts.Face uvWest = this.element.faces.get(class_2350.field_11039);
        float minU = sprite != null ? sprite.method_4594() : 0.0f;
        float maxU = sprite != null ? sprite.method_4577() : 1.0f;
        float minV = sprite != null ? sprite.method_4593() : 0.0f;
        float maxV = sprite != null ? sprite.method_4575() : 1.0f;
        float uRange = maxU - minU;
        float vRange = maxV - minV;
        if (uvDown != null && uvDown.uv != null) {
            u1 = minU + uvDown.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvDown.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvDown.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvDown.uv.v1 / (float)this.textureHeight * vRange;
            float[] v1_arr = AnimatedModelRenderer.getPooledVertex(0);
            v1_arr[0] = xMax;
            v1_arr[1] = y;
            v1_arr[2] = zMax;
            float[] v2_arr = AnimatedModelRenderer.getPooledVertex(1);
            v2_arr[0] = x;
            v2_arr[1] = y;
            v2_arr[2] = zMax;
            float[] v3_arr = AnimatedModelRenderer.getPooledVertex(2);
            v3_arr[0] = x;
            v3_arr[1] = y;
            v3_arr[2] = z;
            float[] v4_arr = AnimatedModelRenderer.getPooledVertex(3);
            v4_arr[0] = xMax;
            v4_arr[1] = y;
            v4_arr[2] = z;
            this.renderForgeQuad(matrices, vertices, v1_arr, v2_arr, v3_arr, v4_arr, u1, v1, u2, v2, 0.0f, -1.0f, 0.0f, light, overlay, red, green, blue, alpha);
        }
        if (uvUp != null && uvUp.uv != null) {
            u1 = minU + uvUp.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvUp.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvUp.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvUp.uv.v1 / (float)this.textureHeight * vRange;
            this.renderForgeQuad(matrices, vertices, new float[]{x, yMax, z}, new float[]{xMax, yMax, z}, new float[]{xMax, yMax, zMax}, new float[]{x, yMax, zMax}, u1, v1, u2, v2, 0.0f, 1.0f, 0.0f, light, overlay, red, green, blue, alpha);
        }
        if (uvWest != null && uvWest.uv != null) {
            u1 = minU + uvWest.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvWest.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvWest.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvWest.uv.v1 / (float)this.textureHeight * vRange;
            this.renderForgeQuad(matrices, vertices, new float[]{x, yMax, zMax}, new float[]{x, yMax, z}, new float[]{x, y, z}, new float[]{x, y, zMax}, u1, v1, u2, v2, -1.0f, 0.0f, 0.0f, light, overlay, red, green, blue, alpha);
        }
        if (uvNorth != null && uvNorth.uv != null) {
            u1 = minU + uvNorth.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvNorth.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvNorth.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvNorth.uv.v1 / (float)this.textureHeight * vRange;
            this.renderForgeQuad(matrices, vertices, new float[]{x, yMax, z}, new float[]{xMax, yMax, z}, new float[]{xMax, y, z}, new float[]{x, y, z}, u1, v1, u2, v2, 0.0f, 0.0f, -1.0f, light, overlay, red, green, blue, alpha);
        }
        if (uvEast != null && uvEast.uv != null) {
            u1 = minU + uvEast.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvEast.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvEast.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvEast.uv.v1 / (float)this.textureHeight * vRange;
            this.renderForgeQuad(matrices, vertices, new float[]{xMax, yMax, z}, new float[]{xMax, yMax, zMax}, new float[]{xMax, y, zMax}, new float[]{xMax, y, z}, u1, v1, u2, v2, 1.0f, 0.0f, 0.0f, light, overlay, red, green, blue, alpha);
        }
        if (uvSouth != null && uvSouth.uv != null) {
            u1 = minU + uvSouth.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvSouth.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvSouth.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvSouth.uv.v1 / (float)this.textureHeight * vRange;
            this.renderForgeQuad(matrices, vertices, new float[]{xMax, yMax, zMax}, new float[]{x, yMax, zMax}, new float[]{x, y, zMax}, new float[]{xMax, y, zMax}, u1, v1, u2, v2, 0.0f, 0.0f, 1.0f, light, overlay, red, green, blue, alpha);
        }
    }

    private void renderForgeQuad(class_4587 matrices, class_4588 vertices, float[] v1, float[] v2, float[] v3, float[] v4, float u1, float v1tex, float u2, float v2tex, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha) {
        class_4587.class_4665 entry = matrices.method_23760();
        float normalLength = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (normalLength > 1.0E-4f) {
            nx /= normalLength;
            ny /= normalLength;
            nz /= normalLength;
        }
        vertices.method_22918(entry.method_23761(), v1[0], v1[1], v1[2]).method_22915(red, green, blue, alpha).method_22913(u1, v1tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
        vertices.method_22918(entry.method_23761(), v2[0], v2[1], v2[2]).method_22915(red, green, blue, alpha).method_22913(u2, v1tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
        vertices.method_22918(entry.method_23761(), v3[0], v3[1], v3[2]).method_22915(red, green, blue, alpha).method_22913(u2, v2tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
        vertices.method_22918(entry.method_23761(), v4[0], v4[1], v4[2]).method_22915(red, green, blue, alpha).method_22913(u1, v2tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
    }

    private void renderQuad(class_4587 matrices, class_4588 vertices, float x1, float y1, float z1, float x2, float y2, float z2, float u1, float v1, float u2, float v2, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha) {
        class_4587.class_4665 entry = matrices.method_23760();
        float normalLength = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (normalLength > 1.0E-4f) {
            nx /= normalLength;
            ny /= normalLength;
            nz /= normalLength;
        }
        if (nz < 0.0f) {
            vertices.method_22918(entry.method_23761(), x2, y1, z1).method_22915(red, green, blue, alpha).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x1, y1, z1).method_22915(red, green, blue, alpha).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x1, y2, z1).method_22915(red, green, blue, alpha).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x2, y2, z1).method_22915(red, green, blue, alpha).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
        } else if (nz > 0.0f) {
            vertices.method_22918(entry.method_23761(), x1, y1, z2).method_22915(red, green, blue, alpha).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x2, y1, z2).method_22915(red, green, blue, alpha).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x2, y2, z2).method_22915(red, green, blue, alpha).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x1, y2, z2).method_22915(red, green, blue, alpha).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
        } else if (nx < 0.0f) {
            vertices.method_22918(entry.method_23761(), x1, y1, z1).method_22915(red, green, blue, alpha).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x1, y1, z2).method_22915(red, green, blue, alpha).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x1, y2, z2).method_22915(red, green, blue, alpha).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x1, y2, z1).method_22915(red, green, blue, alpha).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
        } else if (nx > 0.0f) {
            vertices.method_22918(entry.method_23761(), x2, y1, z2).method_22915(red, green, blue, alpha).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x2, y1, z1).method_22915(red, green, blue, alpha).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x2, y2, z1).method_22915(red, green, blue, alpha).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x2, y2, z2).method_22915(red, green, blue, alpha).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
        } else if (ny < 0.0f) {
            vertices.method_22918(entry.method_23761(), x1, y1, z2).method_22915(red, green, blue, alpha).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x1, y1, z1).method_22915(red, green, blue, alpha).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x2, y1, z1).method_22915(red, green, blue, alpha).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x2, y1, z2).method_22915(red, green, blue, alpha).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
        } else if (ny > 0.0f) {
            vertices.method_22918(entry.method_23761(), x1, y2, z1).method_22915(red, green, blue, alpha).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x1, y2, z2).method_22915(red, green, blue, alpha).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x2, y2, z2).method_22915(red, green, blue, alpha).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), x2, y2, z1).method_22915(red, green, blue, alpha).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
        }
    }

    public void translateAndRotate(class_4587 matrixIn) {
        matrixIn.method_22904((double)(this.pivotX / 16.0f), (double)(this.pivotY / 16.0f), (double)(this.pivotZ / 16.0f));
        if (this.roll != 0.0f) {
            matrixIn.method_22907(class_7833.field_40718.rotationDegrees(this.roll));
        }
        if (this.yaw != 0.0f) {
            matrixIn.method_22907(class_7833.field_40716.rotationDegrees(this.yaw));
        }
        if (this.pitch != 0.0f) {
            matrixIn.method_22907(class_7833.field_40714.rotationDegrees(this.pitch));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ModelBox {
        private final BBModelParts.Element element;
        private final BlockbenchLoader.BlockbenchSetting settings;
        private final int textureWidth;
        private final int textureHeight;

        public ModelBox(float x, float y, float z, float dimX, float dimY, float dimZ, float growX, float growY, float growZ, boolean mirror, int textureWidth, int textureHeight, BBModelParts.Element element, BlockbenchLoader.BlockbenchSetting settings) {
            this.element = element;
            this.settings = settings;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
        }

        public void render(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha, class_1058 sprite) {
            float vHeight;
            float uWidth;
            float minUVArea;
            boolean isZPlane;
            if (this.element == null) {
                return;
            }
            float scale = this.settings != null && this.settings.scale > 0.0f ? this.settings.scale : 1.0f;
            float x = (this.element.from.x - this.element.origin.x) / 16.0f * scale;
            float y = (this.element.from.y - this.element.origin.y) / 16.0f * scale;
            float z = (this.element.from.z - this.element.origin.z) / 16.0f * scale;
            float xMax = (this.element.to.x - this.element.origin.x) / 16.0f * scale;
            float yMax = (this.element.to.y - this.element.origin.y) / 16.0f * scale;
            float zMax = (this.element.to.z - this.element.origin.z) / 16.0f * scale;
            float planeThreshold = 0.001f;
            float zFightOffset = 5.0E-4f;
            boolean isXPlane = Math.abs(xMax - x) < planeThreshold;
            boolean isYPlane = Math.abs(yMax - y) < planeThreshold;
            boolean bl = isZPlane = Math.abs(zMax - z) < planeThreshold;
            if (isXPlane) {
                x -= zFightOffset;
                xMax += zFightOffset;
            }
            if (isYPlane) {
                y -= zFightOffset;
                yMax += zFightOffset;
            }
            if (isZPlane) {
                z -= zFightOffset;
                zMax += zFightOffset;
            }
            BBModelParts.Face uvDown = this.element.faces.get(class_2350.field_11033);
            BBModelParts.Face uvUp = this.element.faces.get(class_2350.field_11036);
            BBModelParts.Face uvNorth = this.element.faces.get(class_2350.field_11043);
            BBModelParts.Face uvSouth = this.element.faces.get(class_2350.field_11035);
            BBModelParts.Face uvEast = this.element.faces.get(class_2350.field_11034);
            BBModelParts.Face uvWest = this.element.faces.get(class_2350.field_11039);
            float minU = sprite != null ? sprite.method_4594() : 0.0f;
            float maxU = sprite != null ? sprite.method_4577() : 1.0f;
            float minV = sprite != null ? sprite.method_4593() : 0.0f;
            float maxV = sprite != null ? sprite.method_4575() : 1.0f;
            float uRange = maxU - minU;
            float vRange = maxV - minV;
            if (uvDown != null && uvDown.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvDown.uv.u1 - uvDown.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvDown.uv.v1 - uvDown.uv.v0)) >= minUVArea) {
                    float[] v1_arr = AnimatedModelRenderer.getPooledVertex(0);
                    v1_arr[0] = xMax;
                    v1_arr[1] = y;
                    v1_arr[2] = zMax;
                    float[] v2_arr = AnimatedModelRenderer.getPooledVertex(1);
                    v2_arr[0] = x;
                    v2_arr[1] = y;
                    v2_arr[2] = zMax;
                    float[] v3_arr = AnimatedModelRenderer.getPooledVertex(2);
                    v3_arr[0] = x;
                    v3_arr[1] = y;
                    v3_arr[2] = z;
                    float[] v4_arr = AnimatedModelRenderer.getPooledVertex(3);
                    v4_arr[0] = xMax;
                    v4_arr[1] = y;
                    v4_arr[2] = z;
                    this.renderForgeTexturedQuad(matrices, vertices, v1_arr, v2_arr, v3_arr, v4_arr, uvDown.uv.u0, uvDown.uv.v0, uvDown.uv.u1, uvDown.uv.v1, this.textureWidth, this.textureHeight, sprite, 0.0f, -1.0f, 0.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
            if (uvUp != null && uvUp.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvUp.uv.u1 - uvUp.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvUp.uv.v1 - uvUp.uv.v0)) >= minUVArea) {
                    this.renderForgeTexturedQuad(matrices, vertices, new float[]{x, yMax, z}, new float[]{xMax, yMax, z}, new float[]{xMax, yMax, zMax}, new float[]{x, yMax, zMax}, uvUp.uv.u0, uvUp.uv.v0, uvUp.uv.u1, uvUp.uv.v1, this.textureWidth, this.textureHeight, sprite, 0.0f, 1.0f, 0.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
            if (uvWest != null && uvWest.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvWest.uv.u1 - uvWest.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvWest.uv.v1 - uvWest.uv.v0)) >= minUVArea) {
                    this.renderForgeTexturedQuad(matrices, vertices, new float[]{x, yMax, zMax}, new float[]{x, yMax, z}, new float[]{x, y, z}, new float[]{x, y, zMax}, uvWest.uv.u0, uvWest.uv.v0, uvWest.uv.u1, uvWest.uv.v1, this.textureWidth, this.textureHeight, sprite, -1.0f, 0.0f, 0.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
            if (uvNorth != null && uvNorth.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvNorth.uv.u1 - uvNorth.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvNorth.uv.v1 - uvNorth.uv.v0)) >= minUVArea) {
                    this.renderForgeTexturedQuad(matrices, vertices, new float[]{x, yMax, z}, new float[]{xMax, yMax, z}, new float[]{xMax, y, z}, new float[]{x, y, z}, uvNorth.uv.u0, uvNorth.uv.v0, uvNorth.uv.u1, uvNorth.uv.v1, this.textureWidth, this.textureHeight, sprite, 0.0f, 0.0f, -1.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
            if (uvEast != null && uvEast.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvEast.uv.u1 - uvEast.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvEast.uv.v1 - uvEast.uv.v0)) >= minUVArea) {
                    this.renderForgeTexturedQuad(matrices, vertices, new float[]{xMax, yMax, z}, new float[]{xMax, yMax, zMax}, new float[]{xMax, y, zMax}, new float[]{xMax, y, z}, uvEast.uv.u0, uvEast.uv.v0, uvEast.uv.u1, uvEast.uv.v1, this.textureWidth, this.textureHeight, sprite, 1.0f, 0.0f, 0.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
            if (uvSouth != null && uvSouth.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvSouth.uv.u1 - uvSouth.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvSouth.uv.v1 - uvSouth.uv.v0)) >= minUVArea) {
                    this.renderForgeTexturedQuad(matrices, vertices, new float[]{xMax, yMax, zMax}, new float[]{x, yMax, zMax}, new float[]{x, y, zMax}, new float[]{xMax, y, zMax}, uvSouth.uv.u0, uvSouth.uv.v0, uvSouth.uv.u1, uvSouth.uv.v1, this.textureWidth, this.textureHeight, sprite, 0.0f, 0.0f, 1.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
        }

        private void renderBlockbenchQuad(class_4587 matrices, class_4588 vertices, float[] v1, float[] v2, float[] v3, float[] v4, float u1, float v1tex, float u2, float v2tex, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha, boolean flipU, boolean flipV) {
            class_4587.class_4665 entry = matrices.method_23760();
            float normalLength = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
            if (normalLength > 1.0E-4f) {
                nx /= normalLength;
                ny /= normalLength;
                nz /= normalLength;
            }
            float finalU1 = flipU ? u2 : u1;
            float finalU2 = flipU ? u1 : u2;
            float finalV1 = flipV ? v2tex : v1tex;
            float finalV2 = flipV ? v1tex : v2tex;
            vertices.method_22918(entry.method_23761(), v1[0], v1[1], v1[2]).method_22915(red, green, blue, alpha).method_22913(finalU1, finalV1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), v2[0], v2[1], v2[2]).method_22915(red, green, blue, alpha).method_22913(finalU1, finalV2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), v3[0], v3[1], v3[2]).method_22915(red, green, blue, alpha).method_22913(finalU2, finalV2).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), v4[0], v4[1], v4[2]).method_22915(red, green, blue, alpha).method_22913(finalU2, finalV1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
        }

        private void renderForgeQuadWithUV(class_4587 matrices, class_4588 vertices, float[] v1, float[] v2, float[] v3, float[] v4, float u1, float v1tex, float u2, float v2tex, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha, boolean flipV) {
            class_4587.class_4665 entry = matrices.method_23760();
            float normalLength = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
            if (normalLength > 1.0E-4f) {
                nx /= normalLength;
                ny /= normalLength;
                nz /= normalLength;
            }
            if (!flipV) {
                vertices.method_22918(entry.method_23761(), v1[0], v1[1], v1[2]).method_22915(red, green, blue, alpha).method_22913(u1, v1tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
                vertices.method_22918(entry.method_23761(), v2[0], v2[1], v2[2]).method_22915(red, green, blue, alpha).method_22913(u1, v2tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
                vertices.method_22918(entry.method_23761(), v3[0], v3[1], v3[2]).method_22915(red, green, blue, alpha).method_22913(u2, v2tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
                vertices.method_22918(entry.method_23761(), v4[0], v4[1], v4[2]).method_22915(red, green, blue, alpha).method_22913(u2, v1tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            } else {
                vertices.method_22918(entry.method_23761(), v3[0], v3[1], v3[2]).method_22915(red, green, blue, alpha).method_22913(u2, v1tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
                vertices.method_22918(entry.method_23761(), v4[0], v4[1], v4[2]).method_22915(red, green, blue, alpha).method_22913(u2, v2tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
                vertices.method_22918(entry.method_23761(), v1[0], v1[1], v1[2]).method_22915(red, green, blue, alpha).method_22913(u1, v2tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
                vertices.method_22918(entry.method_23761(), v2[0], v2[1], v2[2]).method_22915(red, green, blue, alpha).method_22913(u1, v1tex).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            }
        }

        private void renderForgeTexturedQuad(class_4587 matrices, class_4588 vertices, float[] v1, float[] v2, float[] v3, float[] v4, float u0, float v0, float u1, float v1_coord, int textureWidth, int textureHeight, class_1058 sprite, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha, boolean mirror) {
            float finalV1;
            float finalV0;
            float finalU1;
            float finalU0;
            class_4587.class_4665 entry = matrices.method_23760();
            boolean flipU = false;
            boolean flipV = false;
            if (Math.abs(ny) > 0.5f) {
                if (ny > 0.0f) {
                    flipU = false;
                    flipV = mirror;
                } else {
                    flipU = !mirror;
                }
            } else {
                boolean bl = Math.abs(nx) > 0.5f || Math.abs(nz) > 0.5f ? !mirror : (flipU = mirror);
            }
            if (flipU) {
                finalU0 = u1;
                finalU1 = u0;
            } else {
                finalU0 = u0;
                finalU1 = u1;
            }
            if (flipV) {
                finalV0 = v1_coord;
                finalV1 = v0;
            } else {
                finalV0 = v0;
                finalV1 = v1_coord;
            }
            float normalizedU0 = finalU0 / (float)textureWidth;
            float normalizedV0 = finalV0 / (float)textureHeight;
            float normalizedU1 = finalU1 / (float)textureWidth;
            float normalizedV1 = finalV1 / (float)textureHeight;
            float spriteU0 = sprite.method_4594() + (sprite.method_4577() - sprite.method_4594()) * normalizedU0;
            float spriteV0 = sprite.method_4593() + (sprite.method_4575() - sprite.method_4593()) * normalizedV0;
            float spriteU1 = sprite.method_4594() + (sprite.method_4577() - sprite.method_4594()) * normalizedU1;
            float spriteV1 = sprite.method_4593() + (sprite.method_4575() - sprite.method_4593()) * normalizedV1;
            float normalLength = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
            if (normalLength > 1.0E-4f) {
                nx /= normalLength;
                ny /= normalLength;
                nz /= normalLength;
            }
            vertices.method_22918(entry.method_23761(), v1[0], v1[1], v1[2]).method_22915(red, green, blue, alpha).method_22913(spriteU0, spriteV0).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), v2[0], v2[1], v2[2]).method_22915(red, green, blue, alpha).method_22913(spriteU1, spriteV0).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), v3[0], v3[1], v3[2]).method_22915(red, green, blue, alpha).method_22913(spriteU1, spriteV1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
            vertices.method_22918(entry.method_23761(), v4[0], v4[1], v4[2]).method_22915(red, green, blue, alpha).method_22913(spriteU0, spriteV1).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
        }

        private void renderForgeQuad(class_4587 matrices, class_4588 vertices, float[] v1, float[] v2, float[] v3, float[] v4, float u1, float v1tex, float u2, float v2tex, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha) {
            this.renderForgeQuadWithUV(matrices, vertices, v1, v2, v3, v4, u1, v1tex, u2, v2tex, nx, ny, nz, light, overlay, red, green, blue, alpha, false);
        }
    }
}

