/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.screens;

import com.razz.decocraft.common.containers.DecoStorageScreenHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class DecoStorageScreen
extends class_465<DecoStorageScreenHandler> {
    private static final class_2960 CHEST_TEXTURE = new class_2960("minecraft", "textures/gui/container/generic_54.png");
    private final int rows;
    private final int cols;

    public DecoStorageScreen(DecoStorageScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.rows = handler.getRows();
        this.cols = handler.getCols();
        int storageWidth = 7 + this.cols * 18 + 7;
        this.field_2792 = Math.max(176, storageWidth);
        int storageContainerHeight = 17 + this.rows * 18 + 1;
        int storageAreaHeight = 8 + storageContainerHeight;
        int gap = 7;
        int playerInvHeight = 96;
        this.field_2779 = storageAreaHeight + gap + playerInvHeight;
        this.field_25268 = 14;
        this.field_25269 = 8;
        int playerInvStartY = storageAreaHeight + gap;
        this.field_25270 = playerInvStartY + 5;
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int guiX = (this.field_22789 - this.field_2792) / 2;
        int guiY = (this.field_22790 - this.field_2779) / 2;
        int storageWidth = 7 + this.cols * 18 + 7;
        int storageX = guiX + (this.field_2792 - storageWidth) / 2;
        int storageY = guiY + 8;
        this.drawDynamicContainer(context, storageX, storageY, this.cols, this.rows);
        int storageContainerHeight = 17 + this.rows * 18 + 1;
        int actualStorageHeight = 8 + storageContainerHeight;
        int playerInvY = guiY + actualStorageHeight + 7 + 2;
        this.drawPlayerInventoryBackground(context, guiX, playerInvY);
    }

    private void drawDynamicContainer(class_332 context, int x, int y, int cols, int rows) {
        int i;
        int containerWidth = 7 + cols * 18 + 7;
        int containerHeight = 17 + rows * 18 + 1;
        context.method_25302(CHEST_TEXTURE, x, y, 0, 0, 7, 17);
        context.method_25302(CHEST_TEXTURE, x + containerWidth - 7, y, 169, 0, 7, 17);
        context.method_25302(CHEST_TEXTURE, x, y + containerHeight - 1, 0, 215, 7, 1);
        context.method_25302(CHEST_TEXTURE, x + containerWidth - 7, y + containerHeight - 1, 169, 215, 7, 1);
        for (i = 0; i < cols; ++i) {
            context.method_25302(CHEST_TEXTURE, x + 7 + i * 18, y, 7, 0, 18, 17);
        }
        for (int row = 0; row < rows; ++row) {
            int slotY = y + 17 + row * 18;
            context.method_25302(CHEST_TEXTURE, x, slotY, 0, 17, 7, 18);
            for (int col = 0; col < cols; ++col) {
                context.method_25302(CHEST_TEXTURE, x + 7 + col * 18, slotY, 7, 17, 18, 18);
            }
            context.method_25302(CHEST_TEXTURE, x + containerWidth - 7, slotY, 169, 17, 7, 18);
        }
        for (i = 0; i < cols; ++i) {
            context.method_25302(CHEST_TEXTURE, x + 7 + i * 18, y + containerHeight - 1, 7, 215, 18, 1);
        }
    }

    private void drawPlayerInventoryBackground(class_332 context, int x, int y) {
        context.method_25302(CHEST_TEXTURE, x, y, 0, 126, 176, 96);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        int titleWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        int centeredX = (this.field_2792 - titleWidth) / 2;
        context.method_51439(this.field_22793, this.field_22785, centeredX, this.field_25268, 0x404040, false);
        class_5250 inventoryTitle = class_2561.method_43471((String)"container.inventory");
        context.method_51439(this.field_22793, (class_2561)inventoryTitle, this.field_25269, this.field_25270, 0x404040, false);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }
}

