/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class DecocraftTileEntity
extends class_2586 {
    private static final String NBT_COUNTER = "counter";
    private static final String NBT_FRAMETIME = "frametime";
    private static final String NBT_CURRENT_FRAME = "currentFrame";
    private static final String NBT_FRAME_TIMER = "frameTimer";
    private static final String NBT_LIT = "lit";
    public final JsonContainer.Entry meta;
    private int counter;
    private int frametime;
    private boolean lit = true;
    private int currentFrame = 0;
    private int frameTimer = 0;

    public DecocraftTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type != null ? type : ModuleTileEntities.DECOCRAFT, pos, state);
        if (state.method_26204() instanceof DecocraftBlock) {
            this.meta = ((DecocraftBlock)state.method_26204()).meta;
            this.counter = this.meta != null && this.meta.script != null ? this.meta.script.counter : -1;
            this.frametime = this.meta != null && this.meta.flipbook != null ? this.meta.flipbook.frametime : -1;
        } else {
            this.meta = null;
            this.counter = -1;
            this.frametime = -1;
        }
    }

    public DecocraftTileEntity(class_2591<?> type, class_2338 pos, class_2680 state, JsonContainer.Entry meta) {
        super(type, pos, state);
        this.meta = meta;
        this.counter = -1;
        this.frametime = -1;
    }

    public DecocraftTileEntity(JsonContainer.Entry meta) {
        super(ModuleTileEntities.DECOCRAFT, class_2338.field_10980, null);
        if (meta != null) {
            this.meta = meta;
            this.counter = meta.script.counter;
            this.frametime = meta.flipbook.frametime;
        } else {
            this.meta = null;
            this.counter = -1;
            this.frametime = -1;
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, DecocraftTileEntity blockEntity) {
        blockEntity.tick();
    }

    private void tick() {
        if (this.counter >= 0) {
            --this.counter;
            if (this.counter == 0) {
                this.counter = this.meta.script.counter;
                DecocraftBlock.script(this.method_10997(), this.method_11016(), this.method_11010(), this.meta.script.trigger);
            }
        }
        if (this.meta != null && this.meta.script != null && this.meta.script.particles != null && !this.meta.script.particles.isEmpty()) {
            System.out.println("DEBUG: DecocraftTileEntity tick - has particles, world.isClient: " + this.method_10997().field_9236);
            if (this.method_11010().method_26204() instanceof DecocraftBlock) {
                DecocraftBlock block = (DecocraftBlock)this.method_11010().method_26204();
                if (this.method_10997().method_8510() % 3L == 0L) {
                    System.out.println("DEBUG: Calling scriptParticles");
                    DecocraftBlock.scriptParticles(this.method_10997(), this.method_11016(), this.method_11010(), this.meta.script, block.model);
                }
            }
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545(NBT_COUNTER)) {
            this.counter = nbt.method_10550(NBT_COUNTER);
        }
        if (nbt.method_10545(NBT_FRAMETIME)) {
            this.frametime = nbt.method_10550(NBT_FRAMETIME);
        }
        if (nbt.method_10545(NBT_CURRENT_FRAME)) {
            this.currentFrame = nbt.method_10550(NBT_CURRENT_FRAME);
        }
        if (nbt.method_10545(NBT_FRAME_TIMER)) {
            this.frameTimer = nbt.method_10550(NBT_FRAME_TIMER);
        }
        if (nbt.method_10545(NBT_LIT)) {
            this.lit = nbt.method_10577(NBT_LIT);
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569(NBT_COUNTER, this.counter);
        nbt.method_10569(NBT_FRAMETIME, this.frametime);
        nbt.method_10569(NBT_CURRENT_FRAME, this.currentFrame);
        nbt.method_10569(NBT_FRAME_TIMER, this.frameTimer);
        nbt.method_10556(NBT_LIT, this.lit);
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
    }

    private void syncToClients() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.method_11016());
        }
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }
}

