/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBUnbakedModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1091;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class BBModelLoadingPlugin
implements ModelLoadingPlugin {
    public void onInitializeModelLoader(ModelLoadingPlugin.Context pluginContext) {
        System.out.println("BBModelLoadingPlugin: onInitializeModelLoader called");
        pluginContext.resolveModel().register(context -> {
            class_2960 modelId = context.id();
            String namespace = modelId.method_12836();
            String path = modelId.method_12832();
            if ("decocraft".equals(namespace) && path != null) {
                String materialName = null;
                if (modelId instanceof class_1091) {
                    class_1091 blockModelId = (class_1091)modelId;
                    String blockPath = blockModelId.method_12832();
                    if (blockPath != null) {
                        materialName = blockPath;
                    }
                } else if (path.startsWith("block/")) {
                    materialName = path.substring("block/".length());
                } else {
                    if (path.startsWith("item/")) {
                        return null;
                    }
                    materialName = path;
                }
                if (materialName != null && ModuleBlocks.MAT_TO_BB_MODEL.containsKey(materialName)) {
                    BBModel bbModel = ModuleBlocks.MAT_TO_BB_MODEL.get(materialName);
                    System.out.println("BBModelLoadingPlugin: Resolving " + String.valueOf(modelId) + " -> " + materialName + " (has model: " + (bbModel != null) + ")");
                    return new BBUnbakedModel(materialName, bbModel);
                }
                System.out.println("BBModelLoadingPlugin: No model found for " + String.valueOf(modelId) + " (materialName: " + materialName + ", in map: " + ModuleBlocks.MAT_TO_BB_MODEL.containsKey(materialName) + ")");
            }
            return null;
        });
    }
}

