/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelLoader;
import com.razz.decocraft.models.bbmodel.BlockbenchModel;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

@Environment(value=EnvType.CLIENT)
public class BlockbenchLoader {
    public static BlockbenchLoader INSTANCE = new BlockbenchLoader();
    private final Map<BlockbenchSetting, BlockbenchModel> modelCache = Collections.synchronizedMap(new HashMap());
    private class_3300 manager = class_310.method_1551().method_1478();

    public void onResourceManagerReload(class_3300 resourceManager) {
        this.modelCache.clear();
        this.manager = resourceManager;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public BlockbenchModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("model")) {
            throw new RuntimeException("Blockbench Loader requires a 'model' key that points to a valid .BBModel.");
        }
        String modelLocation = modelContents.get("model").getAsString();
        float scale = modelContents.has("scale") ? class_3518.method_15259((JsonObject)modelContents, (String)"scale") : 1.0f;
        boolean flipV = class_3518.method_15258((JsonObject)modelContents, (String)"flip-v", (boolean)false);
        String material = class_3518.method_15253((JsonObject)modelContents, (String)"material", (String)"UNKNOWN");
        BlockbenchSetting settings = new BlockbenchSetting(class_2960.method_12829((String)modelLocation), scale, flipV, material);
        BlockbenchModel cachedModel = this.modelCache.get(settings);
        if (cachedModel != null) {
            return cachedModel;
        }
        try {
            class_3298 resource = (class_3298)this.manager.method_14486(settings.modelLocation).orElseThrow(() -> new FileNotFoundException("Could not find BBModel: " + String.valueOf(settings.modelLocation)));
            try (InputStreamReader lineStream = new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8);){
                BlockbenchModel blockbenchModel;
                try (BufferedReader lineReader = new BufferedReader(lineStream);){
                    BBModel model = new BBModelLoader().loadModel(lineReader);
                    Function<class_2960, class_1058> spriteGetter = id -> {
                        try {
                            class_1058 missingSprite;
                            class_310 client = class_310.method_1551();
                            if (client == null) {
                                return null;
                            }
                            class_1092 bakedModelManager = client.method_1554();
                            if (bakedModelManager == null) {
                                return null;
                            }
                            class_1059 atlas = bakedModelManager.method_24153(class_1723.field_21668);
                            if (atlas == null) {
                                return null;
                            }
                            class_2960 missingTexture = class_2960.method_43902((String)"minecraft", (String)"missingno");
                            class_1058 sprite = atlas.method_4608(id);
                            if (sprite != (missingSprite = atlas.method_4608(missingTexture))) {
                                return sprite;
                            }
                            if (!id.method_12836().equals("decocraft") && (sprite = atlas.method_4608(class_2960.method_43902((String)"decocraft", (String)id.method_12832()))) != missingSprite) {
                                return sprite;
                            }
                            sprite = atlas.method_4608(class_2960.method_43902((String)id.method_12836(), (String)("blocks/" + id.method_12832())));
                            if (sprite != missingSprite) {
                                return sprite;
                            }
                            return missingSprite;
                        }
                        catch (Exception e) {
                            return null;
                        }
                    };
                    BlockbenchModel blockbenchModel2 = new BlockbenchModel(settings, model, spriteGetter);
                    this.modelCache.put(settings, blockbenchModel2);
                    blockbenchModel = blockbenchModel2;
                }
                return blockbenchModel;
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find BBModel", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read BBModel", e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class BlockbenchSetting {
        public final class_2960 modelLocation;
        public final float scale;
        public final boolean flipV;
        public final boolean flipU;
        public final String material;

        public BlockbenchSetting(class_2960 modelLocation, float scale, boolean flipV, String material) {
            this.modelLocation = modelLocation;
            this.scale = scale;
            this.flipV = flipV;
            this.flipU = false;
            this.material = material;
        }

        public BlockbenchSetting(class_2960 modelLocation, float scale, boolean flipV, boolean flipU, String material) {
            this.modelLocation = modelLocation;
            this.scale = scale;
            this.flipV = flipV;
            this.flipU = flipU;
            this.material = material;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockbenchSetting that = (BlockbenchSetting)o;
            return Float.compare(that.scale, this.scale) == 0 && this.flipV == that.flipV && this.flipU == that.flipU && this.modelLocation.equals((Object)that.modelLocation) && this.material.equals(that.material);
        }

        public int hashCode() {
            int result = this.modelLocation.hashCode();
            result = 31 * result + Float.hashCode(this.scale);
            result = 31 * result + Boolean.hashCode(this.flipV);
            result = 31 * result + Boolean.hashCode(this.flipU);
            result = 31 * result + this.material.hashCode();
            return result;
        }
    }
}

