/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.google.common.collect.Sets;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.bbmodel.BlockbenchBakery;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class BlockbenchModel
implements class_1087 {
    private final BlockbenchBakery BAKERY = new BlockbenchBakery();
    private final BlockbenchLoader.BlockbenchSetting settings;
    private final List<BBModelParts.Element> elements;
    private final BBModelParts.Resolution resolution;
    private final List<class_777> bakedQuads;
    private final Map<class_2350, List<class_777>> faceQuads;
    private final class_1058 particleSprite;
    private final class_3665 bakeSettings;

    public BlockbenchModel(BlockbenchLoader.BlockbenchSetting settings, BBModel model, Function<class_2960, class_1058> spriteGetter) {
        this(settings, model, spriteGetter, null);
    }

    public BlockbenchModel(BlockbenchLoader.BlockbenchSetting settings, BBModel model, Function<class_2960, class_1058> spriteGetter, class_3665 bakeSettings) {
        this.settings = settings;
        this.elements = model.elements;
        this.resolution = model.resolution;
        this.bakeSettings = bakeSettings;
        class_2960 particleId = new class_2960(settings.material);
        this.particleSprite = spriteGetter.apply(particleId);
        this.faceQuads = new HashMap<class_2350, List<class_777>>();
        this.bakedQuads = this.buildQuads(spriteGetter);
    }

    private List<class_777> buildQuads(Function<class_2960, class_1058> spriteGetter) {
        ArrayList<class_777> quadList = new ArrayList<class_777>();
        for (class_2350 dir : class_2350.values()) {
            this.faceQuads.put(dir, new ArrayList());
        }
        BBModelParts.Element rootNode = null;
        for (BBModelParts.Element element : this.elements) {
            if (!Objects.equals(element.name.toLowerCase(), "root_node") || !Objects.equals(element.type, "locator")) continue;
            rootNode = element;
        }
        Object textureString = this.settings.material;
        if (!((String)textureString).contains(":")) {
            textureString = "decocraft:" + (String)textureString;
        }
        class_2960 textureId = new class_2960((String)textureString);
        class_1058 texture = spriteGetter.apply(textureId);
        for (BBModelParts.Element element : this.elements) {
            if (element.faces == null) continue;
            for (class_2350 direction : element.faces.keySet()) {
                class_777 quad;
                BBModelParts.Face face = element.faces.get(direction);
                if (face.texture < 0 || face.uv == null || texture == null || (quad = this.BAKERY.bakeQuad(element, this.settings, rootNode, face.uv, this.resolution, texture, direction, this.bakeSettings != null ? this.bakeSettings.method_3509().method_22936() : new Matrix4f())) == null) continue;
                quadList.add(quad);
                if (!this.faceQuads.containsKey(direction)) continue;
                this.faceQuads.get(direction).add(quad);
            }
        }
        return quadList;
    }

    public List<class_777> method_4707(class_2680 state, class_2350 face, class_5819 random) {
        if (face == null) {
            System.out.println("BlockbenchModel.getQuads: Returning " + this.bakedQuads.size() + " quads for null face (material: " + this.settings.material + ")");
            if (state != null && state.method_26204() instanceof DecocraftBlock) {
                DecocraftBlock decoBlock = (DecocraftBlock)state.method_26204();
                if (decoBlock.meta.flipbook != null && decoBlock.meta.flipbook.images > 1) {
                    return this.bakedQuads;
                }
            }
            return this.bakedQuads;
        }
        List<class_777> faceQuadsList = this.faceQuads.getOrDefault(face, Collections.emptyList());
        System.out.println("BlockbenchModel.getQuads: Returning " + faceQuadsList.size() + " quads for face " + String.valueOf(face) + " (material: " + this.settings.material + ")");
        return faceQuadsList;
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.particleSprite;
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public Collection<class_2960> getTextures() {
        HashSet textures = Sets.newHashSet();
        for (BBModelParts.Element element : this.elements) {
            if (element.faces == null) continue;
            for (BBModelParts.Face face : element.faces.values()) {
                String textureString = this.settings.material;
                class_2960 textureId = new class_2960(textureString);
                textures.add(textureId);
            }
        }
        return textures;
    }
}

