/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.razz.decocraft.common.containers.DecobenchContainer;
import com.razz.decocraft.common.groups.GroupSelector;
import com.razz.decocraft.common.items.DecoBlockItem;
import com.razz.decocraft.network.DecocraftPacketHandler;
import com.razz.decocraft.network.client.CDecobenchClick;
import com.razz.decocraft.network.client.CDecobenchCraft;
import com.razz.decocraft.network.client.CDecobenchScroll;
import com.razz.decocraft.network.client.CDecobenchSearch;
import com.razz.decocraft.network.client.CDecobenchSelectTab;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class DecobenchScreen
extends AbstractContainerScreen<DecobenchContainer> {
    private static final ResourceLocation DECOBENCH_LOCATION = new ResourceLocation("decocraft", "gui/decobench.png");
    private static final ResourceLocation RAW_MATERIAL_LOCATION = new ResourceLocation("decocraft", "textures/item/raw_material.png");
    private static final int TABS_LEFT = 48;
    private static final int TABS_HSPACING = 127;
    private static final int TABS_TOP = 21;
    private static final int TABS_WIDTH = 9;
    private static final int TABS_HEIGHT = 9;
    private static final int ELEV_LEFT = 185;
    private static final int ELEV_TOP = 39;
    private static final int ELEV_ARROW_WIDTH = 9;
    private static final int ELEV_ARROW_HEIGHT = 8;
    private static final int ELEV_MAIN_WIDTH = 9;
    private static final int ELEV_MAIN_HEIGHT = 49;
    private static final int ELEV_CURSOR_WIDTH = 9;
    private static final int ELEV_CURSOR_HEIGHT = 6;
    private static final int ELEV_ARROW_VSPACING = 57;
    private static final int ELEV_MAIN_VSPACING = 8;
    private static final int ELEV_CURSOR_VSPACING = 9;
    private static final int CLOSE_LEFT = 188;
    private static final int CLOSE_TOP = 3;
    private static final int CLOSE_WIDTH = 11;
    private static final int CLOSE_HEIGHT = 11;
    private static final int CRAFTING_LEFT = 51;
    private static final int CRAFTING_TOP = 120;
    private static final int CRAFTING_WIDTH = 24;
    private static final int CRAFTING_HEIGHT = 11;
    private static final int SEARCH_LEFT = 188;
    private static final int SEARCH_TOP = 21;
    private static final int SEARCH_WIDTH = 11;
    private static final int SEARCH_HEIGHT = 11;
    private static final int INVENTORY_TOP = 140;
    private static final int INVENTORY_WIDTH = 171;
    private static final int INVENTORY_HEIGHT = 29;
    private static final int COLORS_LEFT = 9;
    private static final int COLORS_TOP = 54;
    private static final int COLORS_SPACING = 9;
    private static final int COLORS_HEIGHT = 25;
    private static final int RAW_MATERIAL_TOP = 107;
    private static final int RAW_MATERIAL_LEFT = 15;
    private static final int RAW_MATERIAL_WIDTH = 14;
    private static final int RAW_MATERIAL_HEIGTH = 16;
    private static final int CRAFTING_BAR_TOP = 122;
    private static final int CRAFTING_BAR_LEFT = 103;
    private static final int CRAFTING_BAR_WIDTH = 62;
    private static final int CRAFTING_BAR_HEIGHT = 7;
    private static final float COLORS_MAX_HEIGHT = 25.0f;
    private static final float CRAFTING_MAX_LENGHT = 60.0f;
    private final List<String> tabs = new ArrayList<String>();
    private float scrollOffset;
    private Button currentButton = Button.NONE;
    private boolean searchMode = false;
    private int currentTab = 0;
    private EditBox searchBox;
    private String prevTab = "all";
    private int elevCurVSpacing = 0;
    private Slot lastSlotClicked;
    private int cursorTimer = 0;
    private int[] cursorUV = new int[]{203, 22};
    private int craftTimer = 0;
    private int[] craftUV = new int[]{203, 66};

    public DecobenchScreen(DecobenchContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97726_ = 203;
        this.f_97727_ = 140;
        this.tabs.add("all");
        GroupSelector.SELECT.forEach((key, value) -> this.tabs.add((String)key));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchBox = new EditBox(this.f_96547_, this.f_97735_ + 49, this.f_97736_ + 21, 133, 9, (Component)new TranslatableComponent("itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94194_(false);
        this.searchBox.m_94202_(0xFFFFFF);
    }

    public void m_181908_() {
        super.m_181908_();
        ++this.cursorTimer;
        if (this.cursorTimer >= 10) {
            this.cursorTimer = 0;
            int n = this.cursorUV[1] = this.cursorUV[1] == 22 ? 44 : 22;
        }
        if (((DecobenchContainer)this.f_97732_).crafting[0] == 0) {
            this.craftUV[0] = 203;
        } else {
            ++this.craftTimer;
            if (this.craftTimer >= 5) {
                this.craftTimer = 0;
                this.craftUV[0] = this.craftUV[0] == 203 ? 222 : 203;
            }
        }
        switch (this.currentButton) {
            case ELEV_UP: 
            case ELEV_MAIN_TOP: {
                this.scrolled(1.0);
                break;
            }
            case ELEV_DOWN: 
            case ELEV_MAIN_BOTTOM: {
                this.scrolled(-1.0);
            }
        }
    }

    public void m_6305_(PoseStack matrix, int x, int y, float partialTicks) {
        this.m_7333_(matrix);
        super.m_6305_(matrix, x, y, partialTicks);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)DECOBENCH_LOCATION);
        DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 185), (int)(this.f_97736_ + 39), (float)229.0f, (float)0.0f, (int)9, (int)8, (int)256, (int)256);
        DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 185), (int)(this.f_97736_ + 39 + 57), (float)229.0f, (float)8.0f, (int)9, (int)8, (int)256, (int)256);
        DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 185), (int)(this.f_97736_ + 39 + 8), (float)247.0f, (float)0.0f, (int)9, (int)49, (int)256, (int)256);
        DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 185), (int)(this.f_97736_ + 39 + 9 + this.elevCurVSpacing), (float)247.0f, (float)49.0f, (int)9, (int)6, (int)256, (int)256);
        DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 188), (int)(this.f_97736_ + 3), (float)225.0f, (float)34.0f, (int)11, (int)11, (int)256, (int)256);
        DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 51), (int)(this.f_97736_ + 120), (float)205.0f, (float)0.0f, (int)24, (int)11, (int)256, (int)256);
        DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 188), (int)(this.f_97736_ + 21), (float)225.0f, (float)45.0f, (int)11, (int)11, (int)256, (int)256);
        if (this.searchMode) {
            DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 188), (int)(this.f_97736_ + 21), (float)236.0f, (float)45.0f, (int)11, (int)11, (int)256, (int)256);
        } else {
            DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 48), (int)(this.f_97736_ + 21), (float)229.0f, (float)16.0f, (int)9, (int)9, (int)256, (int)256);
            DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 48 + 127), (int)(this.f_97736_ + 21), (float)229.0f, (float)25.0f, (int)9, (int)9, (int)256, (int)256);
        }
        switch (this.currentButton) {
            case TABS_LEFT: {
                DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 48), (int)(this.f_97736_ + 21), (float)238.0f, (float)16.0f, (int)9, (int)9, (int)256, (int)256);
                break;
            }
            case TABS_RIGHT: {
                DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 48 + 127), (int)(this.f_97736_ + 21), (float)238.0f, (float)25.0f, (int)9, (int)9, (int)256, (int)256);
                break;
            }
            case ELEV_UP: {
                DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 185), (int)(this.f_97736_ + 39), (float)238.0f, (float)0.0f, (int)9, (int)8, (int)256, (int)256);
                break;
            }
            case ELEV_DOWN: {
                DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 185), (int)(this.f_97736_ + 39 + 57), (float)238.0f, (float)8.0f, (int)9, (int)8, (int)256, (int)256);
                break;
            }
            case ELEV_CURSOR: {
                DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 185), (int)(this.f_97736_ + 39 + 9 + this.elevCurVSpacing), (float)247.0f, (float)55.0f, (int)9, (int)6, (int)256, (int)256);
                break;
            }
            case CLOSE: {
                DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 188), (int)(this.f_97736_ + 3), (float)236.0f, (float)34.0f, (int)11, (int)11, (int)256, (int)256);
            }
        }
        DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 83), (int)(this.f_97736_ + 120), (float)this.craftUV[0], (float)this.craftUV[1], (int)17, (int)13, (int)256, (int)256);
        int[] colorsDisplay = new int[]{(int)Math.ceil(25.0f - (float)((DecobenchContainer)this.f_97732_).colors[0] / 256.0f * 25.0f), (int)Math.ceil(25.0f - (float)((DecobenchContainer)this.f_97732_).colors[1] / 256.0f * 25.0f), (int)Math.ceil(25.0f - (float)((DecobenchContainer)this.f_97732_).colors[2] / 256.0f * 25.0f)};
        this.m_93179_(matrix, this.f_97735_ + 9, this.f_97736_ + 54 + colorsDisplay[0], this.f_97735_ + 9 + 9, this.f_97736_ + 54 + 25, -65536, -65536);
        this.m_93179_(matrix, this.f_97735_ + 9 + 9, this.f_97736_ + 54 + colorsDisplay[1], this.f_97735_ + 9 + 18, this.f_97736_ + 54 + 25, -16711936, -16711936);
        this.m_93179_(matrix, this.f_97735_ + 9 + 18, this.f_97736_ + 54 + colorsDisplay[2], this.f_97735_ + 9 + 27, this.f_97736_ + 54 + 25, -16776961, -16776961);
        DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 7), (int)(this.f_97736_ + 53), (float)203.0f, (float)108.0f, (int)30, (int)33, (int)256, (int)256);
        if (this.lastSlotClicked != null) {
            DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + this.lastSlotClicked.f_40220_ - 5), (int)(this.f_97736_ + this.lastSlotClicked.f_40221_ - 2), (float)this.cursorUV[0], (float)this.cursorUV[1], (int)22, (int)22, (int)256, (int)256);
        }
        if (((DecobenchContainer)this.f_97732_).crafting[0] == 1) {
            DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 51), (int)(this.f_97736_ + 120), (float)205.0f, (float)11.0f, (int)24, (int)11, (int)256, (int)256);
            int crafting = (int)Math.ceil((float)((DecobenchContainer)this.f_97732_).crafting[1] / 40.0f * 60.0f);
            this.m_93179_(matrix, this.f_97735_ + 103 + 1, this.f_97736_ + 122 + 1, this.f_97735_ + 103 + 1 + crafting, this.f_97736_ + 122 + 6, -256, -256);
            DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 103), (int)(this.f_97736_ + 122), (float)171.0f, (float)141.0f, (int)62, (int)7, (int)256, (int)256);
        }
        if (((DecobenchContainer)this.f_97732_).rawMaterial[0] > 0) {
            DecobenchScreen.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 15), (int)(this.f_97736_ + 107), (float)203.0f, (float)92.0f, (int)14, (int)16, (int)256, (int)256);
            String msg = String.valueOf(((DecobenchContainer)this.f_97732_).rawMaterial[0]);
            this.f_96547_.m_92883_(matrix, msg, (float)this.f_97735_ + 22.0f - (float)this.f_96547_.m_92895_(msg) / 2.0f, (float)(this.f_97736_ + 107 + 16), 0xFFFFFF);
        }
        if (this.searchMode) {
            this.searchBox.m_94194_(true);
            this.searchBox.m_94190_(false);
            this.searchBox.m_94178_(true);
            this.searchBox.m_6305_(matrix, x, y, partialTicks);
        } else {
            this.searchBox.m_94194_(false);
            this.searchBox.m_94190_(true);
            this.searchBox.m_94178_(false);
            String tab = StringUtils.capitalize((String)this.tabs.get(this.currentTab));
            this.f_96547_.m_92883_(matrix, tab, (float)this.f_97735_ + 116.0f - (float)this.f_96547_.m_92895_(tab) / 2.0f, (float)(this.f_97736_ + 21), 0xB0B0B0);
        }
        this.m_7025_(matrix, x, y);
    }

    protected void m_7025_(PoseStack matrix, int x, int y) {
        if (this.f_96541_.f_91074_.f_36095_.m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            this.m_6057_(matrix, this.f_97734_.m_7993_(), x, y);
        } else if (x >= this.f_97735_ + 9 && x <= this.f_97735_ + 9 + 27 && y >= this.f_97736_ + 54 && y <= this.f_97736_ + 54 + 25) {
            ArrayList<TranslatableComponent> tooltip = new ArrayList<TranslatableComponent>();
            tooltip.add(new TranslatableComponent(String.format("\u00a7cRed\u00a7r: \u00a7c%d\u00a7r", ((DecobenchContainer)this.f_97732_).colors[0])));
            tooltip.add(new TranslatableComponent(String.format("\u00a72Green\u00a7r: \u00a72%d\u00a7r", ((DecobenchContainer)this.f_97732_).colors[1])));
            tooltip.add(new TranslatableComponent(String.format("\u00a79Blue\u00a7r: \u00a79%d\u00a7r", ((DecobenchContainer)this.f_97732_).colors[2])));
            this.m_96597_(matrix, tooltip, x, y);
        } else if (x >= this.f_97735_ + 15 && x <= this.f_97735_ + 15 + 14 && y >= this.f_97736_ + 107 && y <= this.f_97736_ + 107 + 16) {
            ArrayList<TranslatableComponent> tooltip = new ArrayList<TranslatableComponent>();
            tooltip.add(new TranslatableComponent(String.format("Materials: %d", ((DecobenchContainer)this.f_97732_).rawMaterial[0])));
            this.m_96597_(matrix, tooltip, x, y);
        }
    }

    protected void m_6057_(PoseStack matrix, ItemStack itemStack, int x, int y) {
        List tooltip = itemStack.m_41651_((Player)this.f_96541_.f_91074_, (TooltipFlag)(this.f_96541_.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        if (itemStack.m_41720_() instanceof DecoBlockItem) {
            DecoBlockItem blockItem = (DecoBlockItem)itemStack.m_41720_();
            tooltip.add(new TranslatableComponent(""));
            tooltip.add(new TranslatableComponent(String.format("\u00a7cR\u00a72G\u00a79B\u00a7r: \u00a7c%d \u00a72%d \u00a79%d\u00a7r", blockItem.getRed(), blockItem.getGreen(), blockItem.getBlue())));
            tooltip.add(new TranslatableComponent(String.format("Materials: %d", blockItem.getMaterial())));
        }
        this.m_96597_(matrix, tooltip, x, y);
    }

    protected void m_7027_(PoseStack matrix, int x, int y) {
    }

    protected void m_7286_(PoseStack matrix, float partialTick, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)DECOBENCH_LOCATION);
        int i = this.f_97735_;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrix, i, j, 0, 0, this.f_97726_, this.f_97727_);
        this.m_93228_(matrix, this.f_97735_ + this.f_97726_ / 2 - 85, this.f_97736_ + 140, 0, 141, 171, 29);
    }

    private boolean canScroll() {
        return ((DecobenchContainer)this.f_97732_).canScroll();
    }

    protected void m_6597_(@Nullable Slot slot, int slotId, int button, ClickType clickType) {
        if (slotId < 11) {
            super.m_6597_(slot, slotId, button, ClickType.PICKUP);
        } else {
            this.lastSlotClicked = slot;
            this.cursorTimer = 0;
            DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchClick(slot.m_7993_()));
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        if (button == 0) {
            double d0 = x - (double)this.f_97735_;
            double d1 = y - (double)this.f_97736_;
            if (d0 >= 48.0 && d0 <= 57.0 && d1 >= 21.0 && d1 <= 30.0) {
                this.currentButton = Button.TABS_LEFT;
                --this.currentTab;
                if (this.currentTab < 0) {
                    this.currentTab = this.tabs.size() - 1;
                }
                this.updateTab(this.tabs.get(this.currentTab), 0.0f);
            } else if (d0 >= 175.0 && d0 <= 184.0 && d1 >= 21.0 && d1 <= 30.0) {
                this.currentButton = Button.TABS_RIGHT;
                ++this.currentTab;
                if (this.currentTab >= this.tabs.size()) {
                    this.currentTab = 0;
                }
                this.updateTab(this.tabs.get(this.currentTab), 0.0f);
            } else if (d0 >= 185.0 && d0 <= 194.0 && d1 >= 39.0 && d1 <= 47.0) {
                this.currentButton = Button.ELEV_UP;
            } else if (d0 >= 185.0 && d0 <= 194.0 && d1 >= 96.0 && d1 <= 104.0) {
                this.currentButton = Button.ELEV_DOWN;
            } else if (d0 >= 186.0 && d0 <= 193.0 && d1 >= 48.0 && d1 <= (double)(48 + this.elevCurVSpacing)) {
                this.currentButton = Button.ELEV_MAIN_TOP;
            } else if (d0 >= 186.0 && d0 <= 193.0 && d1 >= (double)(48 + this.elevCurVSpacing + 6) && d1 <= 96.0) {
                this.currentButton = Button.ELEV_MAIN_BOTTOM;
            } else if (d0 >= 185.0 && d0 <= 194.0 && d1 >= (double)(48 + this.elevCurVSpacing) && d1 <= (double)(54 + this.elevCurVSpacing)) {
                this.currentButton = Button.ELEV_CURSOR;
            } else if (d0 >= 188.0 && d0 <= 199.0 && d1 >= 3.0 && d1 <= 14.0) {
                this.currentButton = Button.CLOSE;
                this.f_96541_.m_91152_(null);
            } else if (d0 >= 51.0 && d0 <= 75.0 && d1 >= 120.0 && d1 <= 131.0) {
                this.currentButton = Button.CRAFTING;
                ((DecobenchContainer)this.f_97732_).crafting[0] = ((DecobenchContainer)this.f_97732_).crafting[0] == 0 ? 1 : 0;
                DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchCraft(((DecobenchContainer)this.f_97732_).crafting[0]));
            } else if (d0 >= 188.0 && d0 <= 199.0 && d1 >= 21.0 && d1 <= 32.0) {
                this.currentButton = Button.SEARCH;
                if (this.searchMode) {
                    this.searchMode = false;
                    this.updateTab(this.prevTab, 0.0f);
                } else {
                    this.searchMode = true;
                    this.prevTab = this.tabs.get(this.currentTab);
                    this.updateTab("all", 0.0f);
                    DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchSearch(this.searchBox.m_94155_()));
                }
            } else {
                this.currentButton = Button.NONE;
            }
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        if (button == 0) {
            double d0 = x - (double)this.f_97735_;
            double d1 = y - (double)this.f_97736_;
            this.currentButton = Button.NONE;
        }
        return super.m_6348_(x, y, button);
    }

    public boolean m_7979_(double x, double y, int button, double dragX, double dragY) {
        if (button == 0 && this.currentButton == Button.ELEV_CURSOR) {
            this.scrolled(-dragY * 2.0);
        }
        return super.m_7979_(x, y, button, dragX, dragY);
    }

    public boolean m_6050_(double x, double y, double delta) {
        if (!this.canScroll()) {
            return false;
        }
        this.scrolled(delta);
        return true;
    }

    private void scrolled(double delta) {
        int i = (((DecobenchContainer)this.f_97732_).items.size() + 7 - 1) / 7 - 4;
        this.scrollOffset = (float)((double)this.scrollOffset - delta / (double)i);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.elevCurVSpacing = (int)(this.scrollOffset * 42.0f);
        ((DecobenchContainer)this.f_97732_).scrollTo(this.scrollOffset);
        DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchScroll(this.scrollOffset));
        if (this.lastSlotClicked != null) {
            DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchClick(this.lastSlotClicked.m_7993_()));
        }
    }

    private void updateTab(String name, float offset) {
        ((DecobenchContainer)this.f_97732_).getTabItems(name);
        this.scrollOffset = offset;
        this.scrolled(offset);
        DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchSelectTab(name));
        DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchScroll(offset));
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.searchMode) {
            this.searchBox.m_5534_(pCodePoint, pModifiers);
            DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchSearch(this.searchBox.m_94155_()));
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchMode) {
            this.searchBox.m_7933_(pKeyCode, pScanCode, pModifiers);
            DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchSearch(this.searchBox.m_94155_()));
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private static enum Button {
        NONE,
        TABS_LEFT,
        TABS_RIGHT,
        ELEV_UP,
        ELEV_DOWN,
        ELEV_MAIN_TOP,
        ELEV_MAIN_BOTTOM,
        ELEV_CURSOR,
        CRAFTING,
        CLOSE,
        SEARCH;

    }
}

