/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.razz.decocraft.DecoException;
import com.razz.decocraft.Decocraft;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelLoader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.StringConcatFactory;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.ModList;

public class JsonParser {
    public static String[] parseFiles(String location) {
        String[] strings;
        block10: {
            GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
            Gson gson = gsonBuilder.create();
            System.out.println(Decocraft.class.getResource("/" + location));
            strings = null;
            String[] directories = JsonParser.parseDirectory(location);
            if (directories[0].endsWith("/")) {
                try (FileReader reader = new FileReader(directories[0] + directories[1]);){
                    strings = (String[])gson.fromJson((Reader)reader, String[].class);
                    break block10;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new DecoException("Error! Problem reading text file!");
                }
            }
            String mod = ModList.get().getModFileById("decocraft").getFile().getFilePath().toString();
            try {
                ZipFile zipFile = new ZipFile(mod);
                ZipEntry zipEntry = zipFile.getEntry(location);
                strings = (String[])gson.fromJson((Reader)new InputStreamReader(zipFile.getInputStream(zipEntry)), String[].class);
                zipFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DecoException("Error! Problem reading zip file!");
            }
        }
        return strings;
    }

    public static JsonContainer parseDecocraft(String location) {
        JsonContainer models = null;
        String[] directories = JsonParser.parseDirectory(location);
        if (directories[0].endsWith("/")) {
            models = new JsonContainer((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (String)directories[0], (String)directories[1]))).entries;
        } else {
            String mod = ModList.get().getModFileById("decocraft").getFile().getFilePath().toString();
            try {
                ZipFile zipFile = new ZipFile(mod);
                ZipEntry zipEntry = zipFile.getEntry(location);
                models = new JsonContainer((InputStream)zipFile.getInputStream((ZipEntry)zipEntry)).entries;
                zipFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DecoException("Error! Problem reading " + location);
            }
            if (models == null) {
                throw new DecoException("Error! The number of models is null!");
            }
        }
        return models;
    }

    public static BBModel parseModel(String location, ZipFile zipfile) {
        BBModel model = null;
        String[] directories = JsonParser.parseDirectory(location);
        if (zipfile == null) {
            model = new BBModelLoader().loadModel(directories[0] + directories[1]);
        } else {
            try {
                ZipEntry zipEntry = zipfile.getEntry(location);
                model = new BBModelLoader().loadModel(zipfile.getInputStream(zipEntry));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (model == null) {
                throw new DecoException("Error finding the json. The JAR must contain the 'decocraft' word! | " + location);
            }
        }
        return model;
    }

    private static String[] parseDirectory(String location) {
        URL directory = Decocraft.class.getResource("/" + location);
        if (directory == null) {
            throw new DecoException("Directory not found");
        }
        if (!"union".equals(directory.getProtocol())) {
            throw new DecoException("Protocol unknown");
        }
        Pattern pattern = Pattern.compile("(.*)(\\%\\d+\\!)(.*)");
        Matcher matcher = pattern.matcher(directory.getFile());
        if (!matcher.find()) {
            throw new DecoException("Could not find the file");
        }
        return new String[]{matcher.group(1), matcher.group(3)};
    }

    public static ZipFile openZip() {
        String[] directories = JsonParser.parseDirectory("");
        if (!directories[0].endsWith("/")) {
            String mod = ModList.get().getModFileById("decocraft").getFile().getFilePath().toString();
            try {
                return new ZipFile(mod);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void closeZip(ZipFile zipFile) {
        String[] directories = JsonParser.parseDirectory("");
        if (!directories[0].endsWith("/")) {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

