/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.common.ModuleItems;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.items.DecoBlockItem;
import com.razz.mods.Mods;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class DecomposerTileEntity
extends BlockEntity {
    public static final float CRAFTING_TIME = 40.0f;
    public static final ItemStack DIRT = new ItemStack((ItemLike)Items.f_42329_);
    public static final ItemStack COBBLESTONE = new ItemStack((ItemLike)Items.f_42594_);
    public static final ItemStack RAW_MATERIAL = new ItemStack((ItemLike)ModuleItems.RAW_MATERIAL);
    public static final float FUEL_MAX = 16000.0f;
    private final SimpleContainer input = new SimpleContainer(1);
    private final SimpleContainer result = new SimpleContainer(1);
    private final SimpleContainer fuel = new SimpleContainer(1);
    private int currentFuel = 0;
    private long fuelTimer = 0L;
    private int craft = 0;
    private int craftingTimer = 0;

    public DecomposerTileEntity(BlockPos pos, BlockState state) {
        super(ModuleTileEntities.DECOMPOSER_TE, pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        DecomposerTileEntity be = (DecomposerTileEntity)blockEntity;
        ++be.fuelTimer;
        if (!be.fuel.m_7983_() && be.fuelTimer > 10L) {
            int burnTime = 0;
            if ("".equals("")) {
                burnTime = ForgeHooks.getBurnTime((ItemStack)be.fuel.m_8020_(0), null);
            } else if (be.fuel.m_8020_(0).m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("")))) {
                burnTime = 1600;
            } else {
                return;
            }
            if ((float)(be.currentFuel + burnTime) <= 16000.0f || be.currentFuel == 0) {
                if (be.fuel.m_8020_(0).hasCraftingRemainingItem()) {
                    ItemStack container = be.fuel.m_8020_(0).getCraftingRemainingItem();
                    be.fuel.m_6836_(0, container);
                } else {
                    be.fuel.m_7407_(0, 1);
                }
                be.fuelTimer = 0L;
                be.currentFuel += burnTime;
            }
        }
        if (be.craft == 1 && be.result.m_19183_(RAW_MATERIAL) && be.input.m_8020_(0) != ItemStack.f_41583_) {
            boolean found = be.input.m_8020_(0).m_41720_() instanceof DecoBlockItem;
            if (!found) {
                for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                    if (!be.input.m_8020_(0).m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.getKey()))) && !be.input.m_8020_(0).m_204117_(new TagKey(ForgeRegistries.Keys.ITEMS, new ResourceLocation(entry.getKey()))) || be.input.m_8020_(0).m_41613_() < entry.getValue()) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return;
            }
            if (be.input.m_8020_(0).m_41720_() instanceof DecoBlockItem && ((DecoBlockItem)be.input.m_8020_(0).m_41720_()).getMaterial() + be.result.m_8020_(0).m_41613_() > RAW_MATERIAL.m_41741_()) {
                return;
            }
            if (be.currentFuel > 0) {
                ++be.craftingTimer;
                if ((float)be.craftingTimer >= 40.0f) {
                    be.craftingTimer = 0;
                    if (be.input.m_8020_(0).m_41720_() instanceof DecoBlockItem) {
                        ItemStack stack = RAW_MATERIAL.m_41777_();
                        stack.m_41764_(((DecoBlockItem)be.input.m_8020_(0).m_41720_()).getMaterial());
                        be.input.m_7407_(0, 1);
                        be.result.m_19173_(stack);
                    } else {
                        for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                            if (!be.input.m_8020_(0).m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.getKey()))) && !be.input.m_8020_(0).m_204117_(new TagKey(ForgeRegistries.Keys.ITEMS, new ResourceLocation(entry.getKey())))) continue;
                            be.input.m_7407_(0, entry.getValue().intValue());
                            be.result.m_19173_(RAW_MATERIAL);
                            break;
                        }
                    }
                }
            }
            be.currentFuel -= 10;
            be.currentFuel = Mth.m_14045_((int)be.currentFuel, (int)0, (int)Integer.MAX_VALUE);
        } else {
            be.craftingTimer = 0;
            be.craft = 0;
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.craft = nbt.m_128451_("craft");
        this.craftingTimer = nbt.m_128451_("crafting_timer");
        this.currentFuel = nbt.m_128451_("current_fuel");
        this.result.m_6836_(0, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("result")));
        this.input.m_6836_(0, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("input")));
        this.fuel.m_6836_(0, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("fuel")));
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.saveNBTCustom(nbt);
        this.m_6596_();
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.saveNBTCustom(nbt);
        return nbt;
    }

    private void saveNBTCustom(CompoundTag nbt) {
        nbt.m_128405_("craft", this.craft);
        nbt.m_128405_("crafting_timer", this.craftingTimer);
        nbt.m_128405_("current_fuel", this.currentFuel);
        CompoundTag resultNBT = new CompoundTag();
        this.result.m_8020_(0).m_41739_(resultNBT);
        CompoundTag inputNBT = new CompoundTag();
        this.input.m_8020_(0).m_41739_(inputNBT);
        CompoundTag fuelNBT = new CompoundTag();
        this.fuel.m_8020_(0).m_41739_(fuelNBT);
        nbt.m_128365_("result", (Tag)resultNBT);
        nbt.m_128365_("input", (Tag)inputNBT);
        nbt.m_128365_("fuel", (Tag)fuelNBT);
    }

    public SimpleContainer getInput() {
        return this.input;
    }

    public SimpleContainer getResult() {
        return this.result;
    }

    public SimpleContainer getFuel() {
        return this.fuel;
    }

    public int getCraft() {
        return this.craft;
    }

    public void setCraft(int craft) {
        this.craft = craft;
    }

    public int getCraftingTimer() {
        return this.craftingTimer;
    }

    public int getCurrentFuel() {
        return this.currentFuel;
    }
}

