/*
 * Decompiled with CFR 0.152.
 */
package com.razz.essentialpartnermod;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;

public class Draw {
    public final int mouseX;
    public final int mouseY;
    public final PoseStack matrixStack;
    private static final List<Consumer<Draw>> deferred = new ArrayList<Consumer<Draw>>();

    public Draw(int mouseX, int mouseY, PoseStack matrixStack) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.matrixStack = matrixStack;
    }

    public void rect(int left, int top, int right, int bottom, int color) {
        GuiComponent.m_93172_((PoseStack)this.matrixStack, (int)left, (int)top, (int)right, (int)bottom, (int)color);
    }

    public void texturedRect(ResourceLocation texture, int x, int y, int width, int height, int u, int v, int textureWidth, int textureHeight) {
        this.texturedRect(texture, x, y, width, height, u, v, textureWidth, textureHeight, -1);
    }

    public void texturedRect(ResourceLocation texture, int x, int y, int width, int height, int u, int v, int textureWidth, int textureHeight, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)this.matrixStack, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void string(String text, int x, int y, int color) {
        Minecraft.m_91087_().f_91062_.m_92883_(this.matrixStack, text, (float)x, (float)y, color);
    }

    public void string(String text, int x, int y, int color, int shadowColor) {
        this.string(text, x + 1, y + 1, shadowColor);
        this.string(text, x, y, color);
    }

    public void centredString(String text, int centreX, int y, int color, int shadowColor) {
        int width = Minecraft.m_91087_().f_91062_.m_92895_(text);
        this.string(text, centreX - width / 2, y, color, shadowColor);
    }

    public void multilineCentredString(String text, int centreX, int y, int lineSpacing, int color, int shadowColor) {
        for (String line : text.split("\n")) {
            this.centredString(line, centreX, y, color, shadowColor);
            y += lineSpacing;
        }
    }

    public static boolean hovered(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public boolean hovered(int x, int y, int width, int height) {
        return Draw.hovered(this.mouseX, this.mouseY, x, y, width, height);
    }

    public static void deferred(Consumer<Draw> drawer) {
        deferred.add(drawer);
    }

    public static void flushDeferred(Draw draw) {
        for (Consumer<Draw> drawConsumer : deferred) {
            drawConsumer.accept(draw);
        }
        deferred.clear();
    }
}

