/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.razz.decocraft.DecoException;
import com.razz.decocraft.client.render.AnimatedModelRenderer;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.blocks.DecoAnimatedBlock;
import com.razz.decocraft.common.tileentities.AnimatedTileEntity;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class AnimatedRenderer
implements BlockEntityRenderer<AnimatedTileEntity> {
    private static final String ROOT = "ROOT";
    private static Map<String, TextureAtlasSprite> SPRITE_CACHE = Collections.synchronizedMap(new HashMap());
    private static Map<String, ModelStructure> MODEL_STRUCTURE_CACHE = Collections.synchronizedMap(new HashMap());

    public AnimatedRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(AnimatedTileEntity te, float partialTick, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        te.updateTimer();
        if (!te.hasLevel()) {
            return;
        }
        BlockState state = te.getLevel().getBlockState(te.getBlockPos());
        if (!state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        JsonContainer.Entry meta = null;
        BBModel model = null;
        Block block = state.getBlock();
        if (block instanceof DecoAnimatedBlock) {
            DecoAnimatedBlock block2 = (DecoAnimatedBlock)block;
            meta = block2.meta;
            model = block2.model;
        }
        if (meta == null || model == null) {
            return;
        }
        AnimatedModelRenderer renderer = this.parseModel(meta, model, te);
        ResourceLocation texId = ResourceLocation.fromNamespaceAndPath((String)"decocraft", (String)("block/" + meta.material));
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        TextureAtlas atlas = mc.getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS);
        if (atlas == null) {
            return;
        }
        TextureAtlasSprite sprite = SPRITE_CACHE.get(meta.material);
        if (sprite == null) {
            sprite = atlas.getSprite(texId);
            SPRITE_CACHE.put(meta.material, sprite);
        }
        RenderType layer = RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        VertexConsumer vc = buffer.getBuffer(layer);
        RenderSystem.enablePolygonOffset();
        RenderSystem.polygonOffset((float)-1.0f, (float)-1.0f);
        pose.pushPose();
        pose.mulPose(Axis.YN.rotationDegrees(facing.toYRot()));
        pose.mulPose(Axis.XN.rotationDegrees(180.0f));
        pose.mulPose(Axis.ZN.rotationDegrees(180.0f));
        switch (facing) {
            case NORTH: {
                pose.translate(0.5, 0.0, 0.5);
                break;
            }
            case SOUTH: {
                pose.translate(-0.5, 0.0, -0.5);
                break;
            }
            case EAST: {
                pose.translate(0.5, 0.0, -0.5);
                break;
            }
            case WEST: {
                pose.translate(-0.5, 0.0, 0.5);
            }
        }
        renderer.render(pose, vc, 0xF000F0, overlay, sprite);
        pose.popPose();
        RenderSystem.disablePolygonOffset();
    }

    private AnimatedModelRenderer parseModel(JsonContainer.Entry meta, BBModel model, AnimatedTileEntity te) {
        ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"decocraft", (String)("models/block/" + meta.model + ".bbmodel"));
        BlockbenchLoader.BlockbenchSetting settings = new BlockbenchLoader.BlockbenchSetting(loc, meta.scale > 0.0f ? meta.scale : 1.0f, false, false, meta.material != null ? meta.material : "default");
        AnimatedModelRenderer root = new AnimatedModelRenderer(model.resolution.width, model.resolution.height, null, ROOT, settings);
        Map<UUID, Map<BBModelParts.Channel, float[]>> keyframes = te.getKeyframes();
        this.parseOutliners(model.resolution.width, model.resolution.height, new BBModelParts.ElementBase(), model.outliner, model.uuidMap, root, ROOT, keyframes, settings);
        return root;
    }

    private void parseOutliners(int w, int h, BBModelParts.ElementBase top, List<BBModelParts.OutlinerNode> nodes, Map<UUID, BBModelParts.ElementBase> uuidMap, AnimatedModelRenderer parent, String path, Map<UUID, Map<BBModelParts.Channel, float[]>> keyframes, BlockbenchLoader.BlockbenchSetting settings) {
        for (BBModelParts.OutlinerNode node : nodes) {
            BBModelParts.ElementBase elem;
            if (node instanceof BBModelParts.OutlinerGroup) {
                elem = (BBModelParts.OutlinerGroup)node;
            } else if (node instanceof BBModelParts.OutlinerCube) {
                elem = uuidMap.get(((BBModelParts.OutlinerCube)node).uuid);
            } else {
                throw new DecoException("Invalid outliner node");
            }
            String name = path + "/" + elem.name;
            AnimatedModelRenderer child = new AnimatedModelRenderer(w, h, Objects.equals(elem.type, "cube") && elem instanceof BBModelParts.Element ? (BBModelParts.Element)elem : null, name, settings);
            float[] rot = new float[]{0.0f, 0.0f, 0.0f};
            float[] pos = new float[]{0.0f, 0.0f, 0.0f};
            if (keyframes.get(elem.uuid) != null) {
                if (keyframes.get(elem.uuid).get((Object)BBModelParts.Channel.ROTATION) != null) {
                    rot = keyframes.get(elem.uuid).get((Object)BBModelParts.Channel.ROTATION);
                }
                if (keyframes.get(elem.uuid).get((Object)BBModelParts.Channel.POSITION) != null) {
                    pos = keyframes.get(elem.uuid).get((Object)BBModelParts.Channel.POSITION);
                }
            }
            child.setPivot(elem.origin.x - top.origin.x - pos[0], elem.origin.y - top.origin.y + pos[1], elem.origin.z - top.origin.z + pos[2]);
            child.pitch = elem.rotation.x - rot[0];
            child.yaw = elem.rotation.y - rot[1];
            child.roll = elem.rotation.z + rot[2];
            parent.addChild(child);
            if (Objects.equals(elem.type, "cube") && elem instanceof BBModelParts.Element) {
                BBModelParts.Element e = (BBModelParts.Element)elem;
                if (!(node instanceof BBModelParts.OutlinerCube)) continue;
                child.addCuboid(e.from.x - e.origin.x, e.from.y - e.origin.y, e.from.z - e.origin.z, e.to.x - e.from.x, e.to.y - e.from.y, e.to.z - e.from.z);
                continue;
            }
            BBModelParts.ElementBase group = elem;
            this.parseOutliners(w, h, elem, group.children, uuidMap, child, name, keyframes, settings);
        }
    }

    private static class ModelStructure {
        BBModel model;
        JsonContainer.Entry meta;
        BlockbenchLoader.BlockbenchSetting settings;

        private ModelStructure() {
        }
    }
}

