/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client;

import com.razz.decocraft.client.render.AnimatedRenderer;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleEntities;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecoBedBlock;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelLoadingPlugin;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_6344;

public class ClientEvents
implements ClientModInitializer {
    public void onInitializeClient() {
        System.out.println("=== ClientEvents.onInitializeClient() START ===");
        System.out.println("Registering model loaders...");
        this.registerModelLoaders();
        System.out.println("Model loaders registered successfully");
        System.out.println("Registering block entity renderers...");
        this.registerBlockEntityRenderers();
        System.out.println("Block entity renderers registered successfully");
        System.out.println("Registering entity renderers...");
        this.registerEntityRenderers();
        System.out.println("Entity renderers registered successfully");
        System.out.println("=== ClientEvents.onInitializeClient() END ===");
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            System.out.println("CLIENT_STARTED event - setting up render layers and BB models");
            try {
                this.setupRenderLayers();
                System.out.println("Render layers set up successfully");
                this.registerBBModels();
                System.out.println("BB models registered successfully");
            }
            catch (Exception e) {
                System.err.println("Error during CLIENT_STARTED event:");
                e.printStackTrace();
            }
        });
    }

    private void setupRenderLayers() {
        for (Map.Entry<String, class_2248> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            if (entry.getValue() instanceof DecocraftBlock) {
                DecocraftBlock block = (DecocraftBlock)entry.getValue();
                if (!Objects.equals(block.meta.type, "animated")) {
                    class_1921 renderer = !block.meta.transparency ? class_1921.method_23581() : class_1921.method_23583();
                    BlockRenderLayerMap.INSTANCE.putBlock((class_2248)block, renderer);
                    continue;
                }
                BlockRenderLayerMap.INSTANCE.putBlock((class_2248)block, class_1921.method_23583());
                continue;
            }
            if (!(entry.getValue() instanceof DecoBedBlock)) continue;
            DecoBedBlock bedBlock = (DecoBedBlock)entry.getValue();
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)bedBlock, class_1921.method_23581());
        }
    }

    private void registerModelLoaders() {
        ModelLoadingPlugin.register((ModelLoadingPlugin)new BBModelLoadingPlugin());
    }

    private void registerBBModels() {
        System.out.println("=== Starting BBModel registration ===");
        for (Map.Entry<String, class_2248> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            String materialName = entry.getKey();
            class_2248 block = entry.getValue();
            if (block instanceof DecocraftBlock) {
                DecocraftBlock decoBlock = (DecocraftBlock)block;
                if (decoBlock.model == null) continue;
                this.registerBBModelForBlock(materialName, decoBlock.model, decoBlock.meta);
                continue;
            }
            if (!(block instanceof DecoBedBlock)) continue;
            DecoBedBlock bedBlock = (DecoBedBlock)block;
            if (bedBlock.model == null) continue;
            this.registerBBModelForBlock(materialName, bedBlock.model, bedBlock.meta);
        }
        System.out.println("=== BBModel registration complete ===");
    }

    private void registerBBModelForBlock(String materialName, BBModel model, JsonContainer.Entry meta) {
        float scale = meta.scale != 0.0f ? meta.scale : 1.0f;
    }

    private void registerBlockEntityRenderers() {
        if (ModuleTileEntities.ANIMATED_TE != null) {
            BlockEntityRendererRegistry.register(ModuleTileEntities.ANIMATED_TE, context -> new AnimatedRenderer(context));
        }
    }

    private void registerEntityRenderers() {
        EntityRendererRegistry.register(ModuleEntities.SEAT, class_6344::new);
    }
}

