/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client;

import com.razz.decocraft.client.particles.ParticleFallingLiquid;
import com.razz.decocraft.client.render.AnimatedRenderer;
import com.razz.decocraft.client.render.DecoPlacementRenderer;
import com.razz.decocraft.client.render.UnderlayWorldRenderer;
import com.razz.decocraft.client.screens.DecoStorageScreen;
import com.razz.decocraft.client.screens.DecobenchScreen;
import com.razz.decocraft.client.screens.DecomposerScreen;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleParticleTypes;
import com.razz.decocraft.common.ModuleScreenHandlers;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecoAnimatedBlock;
import com.razz.decocraft.common.blocks.DecoBedBlock;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.network.DecocraftPacketHandler;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_3929;
import net.minecraft.class_5616;

@Environment(value=EnvType.CLIENT)
public class ClientHandler {
    private static boolean bbModelsRegistered = false;

    public static void setup() {
        if (!bbModelsRegistered) {
            ClientHandler.registerBBModels();
            ClientHandler.registerRenderers();
            ClientHandler.registerScreens();
            ClientHandler.registerPlacementPreview();
            ClientHandler.registerParticles();
            ClientHandler.registerClientPackets();
            bbModelsRegistered = true;
        }
    }

    private static void registerParticles() {
        ParticleFactoryRegistry.getInstance().register((class_2396)ModuleParticleTypes.FALLING_WATER, ParticleFallingLiquid.FactoryWaterRandom::new);
    }

    private static void registerClientPackets() {
        DecocraftPacketHandler.registerClientReceivers();
    }

    private static void registerPlacementPreview() {
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((context, hitResult) -> {
            DecoPlacementRenderer.renderPlacementPreview(context);
            return true;
        });
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(context -> UnderlayWorldRenderer.renderUnderlays(context));
    }

    private static void registerRenderers() {
        class_5616.method_32144(ModuleTileEntities.ANIMATED_TE, AnimatedRenderer::new);
    }

    private static void registerScreens() {
        class_3929.method_17542(ModuleScreenHandlers.DECO_STORAGE, DecoStorageScreen::new);
        class_3929.method_17542(ModuleScreenHandlers.DECOBENCH, DecobenchScreen::new);
        class_3929.method_17542(ModuleScreenHandlers.DECOMPOSER, DecomposerScreen::new);
    }

    private static void registerBBModels() {
        for (Map.Entry<String, class_2248> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            String materialName = entry.getKey();
            class_2248 block = entry.getValue();
            if (block instanceof DecocraftBlock) {
                DecocraftBlock decoBlock = (DecocraftBlock)block;
                if (decoBlock.model == null) continue;
                ClientHandler.registerBBModelForBlock(materialName, decoBlock.model, decoBlock.meta);
                continue;
            }
            if (block instanceof DecoAnimatedBlock) {
                DecoAnimatedBlock animatedBlock = (DecoAnimatedBlock)block;
                if (animatedBlock.model == null) continue;
                ClientHandler.registerBBModelForBlock(materialName, animatedBlock.model, animatedBlock.meta);
                continue;
            }
            if (!(block instanceof DecoBedBlock)) continue;
            DecoBedBlock bedBlock = (DecoBedBlock)block;
            if (bedBlock.model == null) continue;
            ClientHandler.registerBBModelForBlock(materialName, bedBlock.model, bedBlock.meta);
        }
    }

    private static void registerBBModelForBlock(String materialName, BBModel model, JsonContainer.Entry meta) {
        try {
            float f = meta.scale != 0.0f ? meta.scale : 1.0f;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

