/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.underlay.UnderlayData;
import com.razz.decocraft.common.underlay.UnderlayManager;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBUnbakedModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_777;
import net.minecraft.class_7833;

public class UnderlayWorldRenderer {
    private static final Map<String, class_1087> MODEL_CACHE = new HashMap<String, class_1087>();
    private static final class_5819 random = class_5819.method_43047();

    public static void renderUnderlays(WorldRenderContext context) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        UnderlayManager manager = UnderlayManager.get((class_1937)client.field_1687);
        Map<class_2338, UnderlayData> underlays = manager.getAllUnderlays();
        if (underlays.isEmpty()) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        class_4597.class_4598 immediate = client.method_22940().method_23000();
        for (Map.Entry<class_2338, UnderlayData> entry : underlays.entrySet()) {
            class_2338 pos = entry.getKey();
            UnderlayData data = entry.getValue();
            if (!data.isValid() || pos.method_19770((class_2374)camera) > 4096.0) continue;
            UnderlayWorldRenderer.renderUnderlay(matrices, (class_4597)immediate, pos, data, (class_1937)context.world(), camera);
        }
        immediate.method_22994(class_1921.method_23577());
        immediate.method_22994(class_1921.method_23581());
        immediate.method_22994(class_1921.method_23579());
        immediate.method_22994(class_1921.method_23583());
        RenderSystem.disableBlend();
    }

    private static void renderUnderlay(class_4587 matrices, class_4597 consumers, class_2338 pos, UnderlayData data, class_1937 world, class_243 camera) {
        String materialId = data.getMaterialId();
        class_1087 model = UnderlayWorldRenderer.getBakedModel(materialId);
        if (model == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904((double)pos.method_10263() - camera.field_1352, (double)pos.method_10264() - camera.field_1351, (double)pos.method_10260() - camera.field_1350);
        class_2350 facing = data.getFacing();
        UnderlayWorldRenderer.applyDirectionRotation(matrices, facing);
        int packedLight = class_761.method_23794((class_1920)world, (class_2338)pos);
        class_4588 buffer = consumers.getBuffer(class_1921.method_23581());
        List quads = model.method_4707(null, null, random);
        for (class_777 quad : quads) {
            buffer.method_22919(matrices.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, class_4608.field_21444);
        }
        for (class_2350 direction : class_2350.values()) {
            List faceQuads = model.method_4707(null, direction, random);
            for (class_777 quad : faceQuads) {
                buffer.method_22919(matrices.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, class_4608.field_21444);
            }
        }
        matrices.method_22909();
    }

    private static class_1087 getBakedModel(String materialId) {
        if (MODEL_CACHE.containsKey(materialId)) {
            return MODEL_CACHE.get(materialId);
        }
        BBModel bbModel = ModuleBlocks.MAT_TO_BB_MODEL.get(materialId);
        if (bbModel == null) {
            System.err.println("[UnderlayWorldRenderer] BBModel not found for: " + materialId);
            return null;
        }
        JsonContainer.Entry entry = ModuleBlocks.MAT_TO_ENTRY.get(materialId);
        if (entry == null) {
            System.err.println("[UnderlayWorldRenderer] Entry not found for: " + materialId);
            return null;
        }
        BBUnbakedModel unbakedModel = new BBUnbakedModel(materialId, bbModel);
        class_310 client = class_310.method_1551();
        class_1087 bakedModel = unbakedModel.method_4753(null, spriteId -> client.method_1554().method_24153(spriteId.method_24144()).method_4608(spriteId.method_24147()), null);
        if (bakedModel != null) {
            MODEL_CACHE.put(materialId, bakedModel);
        }
        return bakedModel;
    }

    private static void applyDirectionRotation(class_4587 matrices, class_2350 facing) {
        matrices.method_22904(0.5, 0.5, 0.5);
        switch (facing) {
            case field_11043: {
                break;
            }
            case field_11035: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11034: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
                break;
            }
        }
        matrices.method_22904(-0.5, -0.5, -0.5);
    }
}

