/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.blocks;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.common.entities.DecoSeatEntity;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class DecoSeatBlock
extends DecocraftBlock {
    private final Map<Integer, class_243> sittingNodes = new TreeMap<Integer, class_243>();
    private static final class_265 SEAT_OUTLINE_SHAPE = class_259.method_1077();
    private static final class_265 SEAT_COLLISION_SHAPE = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);

    public DecoSeatBlock(JsonContainer.Entry meta, BBModel model) {
        super(meta, model);
        this.loadSittingNodes(model, meta.scale);
    }

    private void loadSittingNodes(BBModel model, float scale) {
        for (BBModelParts.ElementBase element : model.outlinerFlatList) {
            if (!(element instanceof BBModelParts.OutlinerGroup)) continue;
            BBModelParts.OutlinerGroup group = (BBModelParts.OutlinerGroup)element;
            if (!"sitting_node".equals(group.name)) continue;
            for (BBModelParts.OutlinerNode child : group.children) {
                if (!(child instanceof BBModelParts.OutlinerCube)) continue;
                BBModelParts.OutlinerCube cube = (BBModelParts.OutlinerCube)child;
                BBModelParts.Element childElement = (BBModelParts.Element)model.uuidMap.get(cube.uuid);
                if (childElement == null) continue;
                class_243 nodePos = this.getNodePosition(childElement, scale);
                try {
                    int nodeId = Integer.parseInt(childElement.name);
                    this.sittingNodes.put(nodeId, nodePos);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    private class_243 getNodePosition(BBModelParts.Element element, float scale) {
        if (element.position != null) {
            return new class_243((double)(element.position.x / 16.0f * scale), (double)(element.position.y / 16.0f * scale), (double)(element.position.z / 16.0f * scale));
        }
        if (element.from != null) {
            return new class_243((double)(element.from.x / 16.0f * scale), (double)(element.from.y / 16.0f * scale), (double)(element.from.z / 16.0f * scale));
        }
        return class_243.field_1353;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481});
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SEAT_OUTLINE_SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SEAT_COLLISION_SHAPE;
    }

    public class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return SEAT_OUTLINE_SHAPE;
    }

    @Override
    protected class_1269 method_55766(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1657 playerEntity, class_3965 blockRayTraceResult) {
        List seats;
        if (!world.field_9236 && (seats = world.method_8390(DecoSeatEntity.class, new class_238((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (double)blockPos.method_10263() + 1.0, (double)blockPos.method_10264() + 1.0, (double)blockPos.method_10260() + 1.0), entity -> true)).isEmpty()) {
            class_243 offset = this.sittingNodes.get(0);
            if (offset == null) {
                offset = class_243.field_1353;
            }
            class_2350 direction = (class_2350)blockState.method_11654((class_2769)class_2741.field_12481);
            class_243 rotatedOffset = DecoSeatBlock.rotatePosition(offset, direction);
            class_243 vect = new class_243(0.5 + rotatedOffset.field_1352, -0.6 + rotatedOffset.field_1351, 0.5 + rotatedOffset.field_1350);
            DecoSeatEntity seat = new DecoSeatEntity(world, blockPos, vect);
            world.method_8649((class_1297)seat);
            playerEntity.method_5873((class_1297)seat, false);
        }
        return class_1269.field_5812;
    }

    private static class_243 rotatePosition(class_243 pos, class_2350 facing) {
        switch (facing) {
            case field_11043: {
                return pos;
            }
            case field_11035: {
                return new class_243(-pos.field_1352, pos.field_1351, -pos.field_1350);
            }
            case field_11034: {
                return new class_243(-pos.field_1350, pos.field_1351, pos.field_1352);
            }
            case field_11039: {
                return new class_243(pos.field_1350, pos.field_1351, -pos.field_1352);
            }
        }
        return pos;
    }
}

