/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleParticleTypes;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.libgdx.Vector3;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class DecocraftTileEntity
extends class_2586 {
    private static final String NBT_COUNTER = "counter";
    private static final String NBT_FRAMETIME = "frametime";
    private static final String NBT_CURRENT_FRAME = "currentFrame";
    private static final String NBT_FRAME_TIMER = "frameTimer";
    private static final String NBT_LIT = "lit";
    private static final String NBT_PARTICLE_TIMER = "particleTimer";
    public final JsonContainer.Entry meta;
    private int counter;
    private int frametime;
    private boolean lit = true;
    private int currentFrame = 0;
    private int frameTimer = 0;
    private int particleTimer = 0;

    public DecocraftTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type != null ? type : ModuleTileEntities.DECOCRAFT, pos, state);
        if (state.method_26204() instanceof DecocraftBlock) {
            this.meta = ((DecocraftBlock)state.method_26204()).meta;
            this.counter = this.meta != null && this.meta.script != null ? this.meta.script.counter : -1;
            this.frametime = this.meta != null && this.meta.flipbook != null ? this.meta.flipbook.frametime : -1;
        } else {
            this.meta = null;
            this.counter = -1;
            this.frametime = -1;
        }
    }

    public DecocraftTileEntity(class_2591<?> type, class_2338 pos, class_2680 state, JsonContainer.Entry meta) {
        super(type, pos, state);
        this.meta = meta;
        this.counter = -1;
        this.frametime = -1;
    }

    public DecocraftTileEntity(JsonContainer.Entry meta) {
        super(ModuleTileEntities.DECOCRAFT, class_2338.field_10980, null);
        if (meta != null) {
            this.meta = meta;
            this.counter = meta.script.counter;
            this.frametime = meta.flipbook.frametime;
        } else {
            this.meta = null;
            this.counter = -1;
            this.frametime = -1;
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, DecocraftTileEntity blockEntity) {
        blockEntity.tick();
    }

    private void tick() {
        if (this.counter >= 0) {
            --this.counter;
            if (this.counter == 0) {
                this.counter = this.meta.script.counter;
                DecocraftBlock.script(this.method_10997(), this.method_11016(), this.method_11010(), this.meta.script.trigger);
            }
        }
        if (this.meta != null && this.meta.script != null && this.meta.script.particles != null && !this.meta.script.particles.isEmpty()) {
            ++this.particleTimer;
            if (this.particleTimer >= 3) {
                this.particleTimer = 0;
                this.spawnParticles();
            }
        }
    }

    private void spawnParticles() {
        class_1937 world = this.method_10997();
        if (world == null || world.field_9236) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_2680 state = this.method_11010();
        if (state == null || !(state.method_26204() instanceof DecocraftBlock)) {
            return;
        }
        DecocraftBlock block = (DecocraftBlock)state.method_26204();
        BBModel model = block.model;
        if (model == null) {
            return;
        }
        class_2350 facing = state.method_28498((class_2769)class_2741.field_12481) ? (class_2350)state.method_11654((class_2769)class_2741.field_12481) : class_2350.field_11043;
        Map<String, Vector3> locators = model.getLocators();
        for (Map.Entry<String, JsonContainer.Particle> entry : this.meta.script.particles.entrySet()) {
            String anchorName = entry.getKey();
            JsonContainer.Particle particleConfig = entry.getValue();
            Vector3 locatorPos = locators.get(anchorName);
            if (locatorPos == null) {
                locatorPos = this.getFallbackPosition(anchorName, block.meta.model);
            }
            if (locatorPos == null) continue;
            double x = (double)this.field_11867.method_10263() + 0.5 + this.rotateX((double)locatorPos.x / 16.0, (double)locatorPos.z / 16.0, facing);
            double y = (double)this.field_11867.method_10264() + (double)locatorPos.y / 16.0;
            double z = (double)this.field_11867.method_10260() + 0.5 + this.rotateZ((double)locatorPos.x / 16.0, (double)locatorPos.z / 16.0, facing);
            class_2394 particleType = this.getParticleType(particleConfig.name);
            if (particleType == null) continue;
            double vx = particleConfig.vx;
            double vy = particleConfig.vy;
            double vz = particleConfig.vz;
            serverWorld.method_14199(particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private Vector3 getFallbackPosition(String anchorName, String modelName) {
        if (modelName != null && modelName.equals("shower_system")) {
            switch (anchorName) {
                case "water_1": {
                    return new Vector3(-2.0f, 20.5f, 6.5f);
                }
                case "water_2": {
                    return new Vector3(0.0f, 20.5f, 6.5f);
                }
                case "water_3": {
                    return new Vector3(2.0f, 20.5f, 6.5f);
                }
                case "water_4": {
                    return new Vector3(-1.0f, 20.5f, 6.5f);
                }
                case "water_5": {
                    return new Vector3(1.0f, 20.5f, 6.5f);
                }
            }
        }
        return null;
    }

    private double rotateX(double x, double z, class_2350 facing) {
        switch (facing) {
            case field_11043: {
                return -x;
            }
            case field_11035: {
                return x;
            }
            case field_11034: {
                return -z;
            }
            case field_11039: {
                return z;
            }
        }
        return -x;
    }

    private double rotateZ(double x, double z, class_2350 facing) {
        switch (facing) {
            case field_11043: {
                return -z;
            }
            case field_11035: {
                return z;
            }
            case field_11034: {
                return x;
            }
            case field_11039: {
                return -x;
            }
        }
        return -z;
    }

    private class_2394 getParticleType(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("decocraft:")) {
            String particleName;
            switch (particleName = name.substring("decocraft:".length())) {
                case "falling_water_random": {
                    return ModuleParticleTypes.FALLING_WATER;
                }
                case "smoke_normal": {
                    return ModuleParticleTypes.SMOKE_NORMAL;
                }
                case "smoke_small": {
                    return ModuleParticleTypes.SMOKE_SMALL;
                }
                case "flame_normal": {
                    return ModuleParticleTypes.FLAME_NORMAL;
                }
                case "flame_small": {
                    return ModuleParticleTypes.FLAME_SMALL;
                }
            }
        } else if (name.startsWith("minecraft:")) {
            String particleName;
            switch (particleName = name.substring("minecraft:".length())) {
                case "splash": {
                    return class_2398.field_11202;
                }
                case "bubble": {
                    return class_2398.field_11247;
                }
                case "dripping_water": {
                    return class_2398.field_11232;
                }
                case "falling_water": {
                    return class_2398.field_18306;
                }
            }
        }
        return null;
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10545(NBT_COUNTER)) {
            this.counter = nbt.method_10550(NBT_COUNTER);
        }
        if (nbt.method_10545(NBT_FRAMETIME)) {
            this.frametime = nbt.method_10550(NBT_FRAMETIME);
        }
        if (nbt.method_10545(NBT_CURRENT_FRAME)) {
            this.currentFrame = nbt.method_10550(NBT_CURRENT_FRAME);
        }
        if (nbt.method_10545(NBT_FRAME_TIMER)) {
            this.frameTimer = nbt.method_10550(NBT_FRAME_TIMER);
        }
        if (nbt.method_10545(NBT_LIT)) {
            this.lit = nbt.method_10577(NBT_LIT);
        }
        if (nbt.method_10545(NBT_PARTICLE_TIMER)) {
            this.particleTimer = nbt.method_10550(NBT_PARTICLE_TIMER);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569(NBT_COUNTER, this.counter);
        nbt.method_10569(NBT_FRAMETIME, this.frametime);
        nbt.method_10569(NBT_CURRENT_FRAME, this.currentFrame);
        nbt.method_10569(NBT_FRAME_TIMER, this.frameTimer);
        nbt.method_10556(NBT_LIT, this.lit);
        nbt.method_10569(NBT_PARTICLE_TIMER, this.particleTimer);
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
    }

    private void syncToClients() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.method_11016());
        }
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }
}

