/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.underlay;

import com.razz.decocraft.common.underlay.UnderlayData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class UnderlayManager
extends class_18 {
    private static final String DATA_NAME = "decocraft_underlays";
    private final Map<class_2338, UnderlayData> underlays = new ConcurrentHashMap<class_2338, UnderlayData>();
    private static UnderlayManager clientInstance = null;

    public static UnderlayManager get(class_1937 world) {
        if (world.field_9236) {
            if (clientInstance == null) {
                clientInstance = new UnderlayManager();
            }
            return clientInstance;
        }
        class_3218 serverWorld = (class_3218)world;
        return (UnderlayManager)serverWorld.method_17983().method_17924(new class_18.class_8645(UnderlayManager::new, UnderlayManager::fromNbt, null), DATA_NAME);
    }

    public void setUnderlay(class_2338 pos, UnderlayData data) {
        if (data.isValid()) {
            this.underlays.put(pos.method_10062(), data);
            this.method_80();
        }
    }

    public UnderlayData getUnderlay(class_2338 pos) {
        return this.underlays.getOrDefault(pos, UnderlayData.NONE);
    }

    public void removeUnderlay(class_2338 pos) {
        if (this.underlays.remove(pos) != null) {
            this.method_80();
            System.out.println("[UnderlayManager] Removed underlay at " + String.valueOf(pos));
        }
    }

    public boolean hasUnderlay(class_2338 pos) {
        return this.underlays.containsKey(pos) && this.underlays.get(pos).isValid();
    }

    public Map<class_2338, UnderlayData> getAllUnderlays() {
        return new HashMap<class_2338, UnderlayData>(this.underlays);
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2499 list = new class_2499();
        for (Map.Entry<class_2338, UnderlayData> entry : this.underlays.entrySet()) {
            class_2487 entryNbt = new class_2487();
            class_2338 pos = entry.getKey();
            entryNbt.method_10569("x", pos.method_10263());
            entryNbt.method_10569("y", pos.method_10264());
            entryNbt.method_10569("z", pos.method_10260());
            entryNbt.method_10566("data", (class_2520)entry.getValue().toNbt());
            list.add((Object)entryNbt);
        }
        nbt.method_10566("underlays", (class_2520)list);
        return nbt;
    }

    public static UnderlayManager fromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        UnderlayManager manager = new UnderlayManager();
        if (nbt.method_10545("underlays")) {
            class_2499 list = nbt.method_10554("underlays", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 entryNbt = list.method_10602(i);
                class_2338 pos = new class_2338(entryNbt.method_10550("x"), entryNbt.method_10550("y"), entryNbt.method_10550("z"));
                UnderlayData data = UnderlayData.fromNbt(entryNbt.method_10562("data"));
                if (!data.isValid()) continue;
                manager.underlays.put(pos, data);
            }
        }
        return manager;
    }
}

