/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import com.razz.decocraft.models.libgdx.Matrix4;
import com.razz.decocraft.models.libgdx.Quaternion;
import com.razz.decocraft.models.libgdx.Vector3;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_777;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class BlockbenchBakery {
    private static Vector3 vec3iToVec3(class_2382 vec3i) {
        return new Vector3(vec3i.method_10263(), vec3i.method_10264(), vec3i.method_10260());
    }

    public class_777 bakeQuad(BBModelParts.Element element, BlockbenchLoader.BlockbenchSetting settings, BBModelParts.Element rootNode, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, class_1058 texture, class_2350 direc, Matrix4f modelTransform) {
        float vHeight;
        float uWidth = Math.abs(uvs.u1 - uvs.u0);
        float uvArea = uWidth * (vHeight = Math.abs(uvs.v1 - uvs.v0));
        if (uvArea < 0.01f) {
            return null;
        }
        int[] vertices = this.makeVertices(element, settings, rootNode, uvs, resolution, texture, direc, this.setupShape(element.from, element.to, element.inflate), modelTransform);
        class_2350 direction = this.calculateFacing(vertices);
        this.fillNormals(vertices, direction);
        return new class_777(vertices, -1, direction, texture, element.shade);
    }

    private int[] makeVertices(BBModelParts.Element element, BlockbenchLoader.BlockbenchSetting setting, BBModelParts.Element rootNode, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, class_1058 texture, class_2350 direction, float[] positions, Matrix4f transformationMatrix) {
        int[] vertices = new int[32];
        for (int i = 0; i < 4; ++i) {
            this.bakeVertex(vertices, i, rootNode, direction, setting, uvs, resolution, positions, texture, transformationMatrix, element);
        }
        return vertices;
    }

    private void bakeVertex(int[] vertices, int index, BBModelParts.Element rootNode, class_2350 direction, BlockbenchLoader.BlockbenchSetting setting, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, float[] positions, class_1058 texture, Matrix4f transformationMatrix, BBModelParts.Element element) {
        FaceInfo.VertexInfo vertexInfo = FaceInfo.fromFacing(direction).getVertexInfo(index);
        Vector3 pos = new Vector3(positions[vertexInfo.xFace], positions[vertexInfo.yFace], positions[vertexInfo.zFace]);
        this.applyElementRotation(pos, element);
        Matrix4 mat4 = new Matrix4();
        this.applyTransform(pos, mat4.setToScaling(setting.scale, setting.scale, setting.scale));
        this.applyTransform(pos, mat4.setToTranslation(0.5f, 0.0f, 0.5f));
        if (rootNode != null) {
            if (rootNode.position != null) {
                this.applyTransform(pos, mat4.setToTranslation(-rootNode.position.x / 16.0f, -rootNode.position.y / 16.0f, -rootNode.position.z / 16.0f));
            } else if (rootNode.from != null) {
                this.applyTransform(pos, mat4.setToTranslation(-rootNode.from.x / 16.0f, -rootNode.from.y / 16.0f, -rootNode.from.z / 16.0f));
            }
        }
        this.applyModelRotation(pos, new Vector3(0.5f, 0.5f, 0.5f), transformationMatrix);
        this.fillVertex(vertices, index, setting, pos, texture, uvs, resolution);
    }

    private void applyTransform(Vector3 pos, Matrix4 trans) {
        pos.set(trans.val[0] * pos.x + trans.val[4] * pos.y + trans.val[8] * pos.z + trans.val[12] * 1.0f, trans.val[1] * pos.x + trans.val[5] * pos.y + trans.val[9] * pos.z + trans.val[13] * 1.0f, trans.val[2] * pos.x + trans.val[6] * pos.y + trans.val[10] * pos.z + trans.val[14] * 1.0f);
    }

    private void rotateVertexBy(Vector3 pos, Vector3 origin, Matrix4 mat4) {
        Vector3 delta = new Vector3(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z);
        this.applyTransform(delta, mat4);
        pos.set(delta.x + origin.x, delta.y + origin.y, delta.z + origin.z);
    }

    private void rotateVertexBy(Vector3 pos, Vector3 origin, Matrix4f mat4) {
        Vector4f delta = new Vector4f(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z, 1.0f);
        delta.mul((Matrix4fc)mat4);
        pos.set(delta.x() + origin.x, delta.y() + origin.y, delta.z() + origin.z);
    }

    private void applyModelRotation(Vector3 pos, Vector3 rot, Matrix4f transformationMatrix) {
        Matrix4f identity = new Matrix4f();
        if (!transformationMatrix.equals((Object)identity)) {
            this.rotateVertexBy(pos, rot, transformationMatrix);
        }
    }

    private void applyElementRotation(Vector3 pos, BBModelParts.Element element) {
        Vector3 origin = element.origin;
        Vector3 rotation = element.rotation;
        BBModelParts.OutlinerGroup parent = element.parent;
        Quaternion quaternion = new Quaternion();
        while (true) {
            Vector3 originWorld = new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f);
            if (rotation.x != 0.0f) {
                quaternion.set(Vector3.X, rotation.x);
                this.rotateVertexBy(pos, originWorld, new Matrix4(quaternion));
            }
            if (rotation.y != 0.0f) {
                quaternion.set(Vector3.Y, rotation.y);
                this.rotateVertexBy(pos, originWorld, new Matrix4(quaternion));
            }
            if (rotation.z != 0.0f) {
                quaternion.set(Vector3.Z, rotation.z);
                this.rotateVertexBy(pos, originWorld, new Matrix4(quaternion));
            }
            if (parent == null) break;
            origin = parent.origin;
            rotation = parent.rotation;
            parent = parent.parent;
        }
    }

    private void fillVertex(int[] vertices, int index, BlockbenchLoader.BlockbenchSetting setting, Vector3 pos, class_1058 texture, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution) {
        int i = index * 8;
        boolean uInverted = uvs.u1 < uvs.u0;
        boolean vInverted = uvs.v1 < uvs.v0;
        float uMin = Math.min(uvs.u0, uvs.u1);
        float uMax = Math.max(uvs.u0, uvs.u1);
        float vMin = Math.min(uvs.v0, uvs.v1);
        float vMax = Math.max(uvs.v0, uvs.v1);
        float u = -1.0f;
        float v = -1.0f;
        boolean flipU = uInverted;
        boolean flipV = vInverted ^ setting.flipV;
        if (!flipV) {
            switch (index) {
                case 0: {
                    u = flipU ? uMax : uMin;
                    v = vMin;
                    break;
                }
                case 1: {
                    u = flipU ? uMax : uMin;
                    v = vMax;
                    break;
                }
                case 2: {
                    u = flipU ? uMin : uMax;
                    v = vMax;
                    break;
                }
                case 3: {
                    u = flipU ? uMin : uMax;
                    v = vMin;
                }
            }
        } else {
            switch (index) {
                case 2: {
                    u = flipU ? uMin : uMax;
                    v = vMin;
                    break;
                }
                case 3: {
                    u = flipU ? uMin : uMax;
                    v = vMax;
                    break;
                }
                case 0: {
                    u = flipU ? uMax : uMin;
                    v = vMax;
                    break;
                }
                case 1: {
                    u = flipU ? uMax : uMin;
                    v = vMin;
                }
            }
        }
        float normalizedU = u / (float)resolution.width;
        float normalizedV = v / (float)resolution.height;
        float spriteU = texture.method_4594() + (texture.method_4577() - texture.method_4594()) * normalizedU;
        float spriteV = texture.method_4593() + (texture.method_4575() - texture.method_4593()) * normalizedV;
        vertices[i] = Float.floatToRawIntBits(pos.x);
        vertices[i + 1] = Float.floatToRawIntBits(pos.y);
        vertices[i + 2] = Float.floatToRawIntBits(pos.z);
        vertices[i + 3] = -1;
        vertices[i + 4] = Float.floatToRawIntBits(spriteU);
        vertices[i + 4 + 1] = Float.floatToRawIntBits(spriteV);
    }

    private float[] setupShape(Vector3 from, Vector3 to, float inflate) {
        float[] afloat = new float[class_2350.values().length];
        afloat[0] = (from.x - inflate / 2.0f) / 16.0f;
        afloat[1] = (from.y - inflate / 2.0f) / 16.0f;
        afloat[2] = (from.z - inflate / 2.0f) / 16.0f;
        afloat[3] = (to.x + inflate / 2.0f) / 16.0f;
        afloat[4] = (to.y + inflate / 2.0f) / 16.0f;
        afloat[5] = (to.z + inflate / 2.0f) / 16.0f;
        return afloat;
    }

    private class_2350 calculateFacing(int[] vertices) {
        Vector3 pos1 = new Vector3(Float.intBitsToFloat(vertices[0]), Float.intBitsToFloat(vertices[1]), Float.intBitsToFloat(vertices[2]));
        Vector3 pos2 = new Vector3(Float.intBitsToFloat(vertices[8]), Float.intBitsToFloat(vertices[9]), Float.intBitsToFloat(vertices[10]));
        Vector3 pos3 = new Vector3(Float.intBitsToFloat(vertices[16]), Float.intBitsToFloat(vertices[17]), Float.intBitsToFloat(vertices[18]));
        Vector3 delta1 = pos1.cpy();
        delta1.sub(pos2);
        Vector3 delta2 = pos3.cpy();
        delta2.sub(pos2);
        Vector3 cross = delta2.cpy();
        cross.crs(delta1);
        cross.nor();
        class_2350 direction = null;
        float f = 0.0f;
        for (class_2350 direc : class_2350.values()) {
            Vector3 normal = BlockbenchBakery.vec3iToVec3(direc.method_10163());
            float f1 = cross.dot(normal);
            if (!(f1 >= 0.0f) || !(f1 > f)) continue;
            f = f1;
            direction = direc;
        }
        return direction == null ? class_2350.field_11036 : direction;
    }

    private int packNormal(float x, float y, float z) {
        int nx = (int)(x * 127.0f) & 0xFF;
        int ny = (int)(y * 127.0f) & 0xFF;
        int nz = (int)(z * 127.0f) & 0xFF;
        return nx | ny << 8 | nz << 16;
    }

    private void fillNormals(int[] vertices, class_2350 direction) {
        class_2382 normal = direction.method_10163();
        int packedNormal = this.packNormal(normal.method_10263(), normal.method_10264(), normal.method_10260());
        for (int i = 0; i < 4; ++i) {
            int offset = i * 8;
            vertices[offset + 6] = 0;
            vertices[offset + 7] = packedNormal;
        }
    }

    private static class FaceInfo {
        private final VertexInfo[] vertexInfos;

        private FaceInfo(VertexInfo[] vertexInfos) {
            this.vertexInfos = vertexInfos;
        }

        public VertexInfo getVertexInfo(int index) {
            return this.vertexInfos[index];
        }

        public static FaceInfo fromFacing(class_2350 direction) {
            switch (direction) {
                case field_11033: {
                    return new FaceInfo(new VertexInfo[]{new VertexInfo(0, 1, 5), new VertexInfo(0, 1, 2), new VertexInfo(3, 1, 2), new VertexInfo(3, 1, 5)});
                }
                case field_11036: {
                    return new FaceInfo(new VertexInfo[]{new VertexInfo(0, 4, 2), new VertexInfo(0, 4, 5), new VertexInfo(3, 4, 5), new VertexInfo(3, 4, 2)});
                }
                case field_11043: {
                    return new FaceInfo(new VertexInfo[]{new VertexInfo(3, 4, 2), new VertexInfo(3, 1, 2), new VertexInfo(0, 1, 2), new VertexInfo(0, 4, 2)});
                }
                case field_11035: {
                    return new FaceInfo(new VertexInfo[]{new VertexInfo(0, 4, 5), new VertexInfo(0, 1, 5), new VertexInfo(3, 1, 5), new VertexInfo(3, 4, 5)});
                }
                case field_11039: {
                    return new FaceInfo(new VertexInfo[]{new VertexInfo(0, 4, 2), new VertexInfo(0, 1, 2), new VertexInfo(0, 1, 5), new VertexInfo(0, 4, 5)});
                }
                case field_11034: {
                    return new FaceInfo(new VertexInfo[]{new VertexInfo(3, 4, 5), new VertexInfo(3, 1, 5), new VertexInfo(3, 1, 2), new VertexInfo(3, 4, 2)});
                }
            }
            throw new IllegalArgumentException();
        }

        public static class VertexInfo {
            public final int xFace;
            public final int yFace;
            public final int zFace;

            VertexInfo(int x, int y, int z) {
                this.xFace = x;
                this.yFace = y;
                this.zFace = z;
            }
        }

        public static class Constants {
            public static final int MIN_X = 0;
            public static final int MIN_Y = 1;
            public static final int MIN_Z = 2;
            public static final int MAX_X = 3;
            public static final int MAX_Y = 4;
            public static final int MAX_Z = 5;
        }
    }
}

