/*
 * Decompiled with CFR 0.152.
 */
package com.github.voidleech.oblivion;

import com.github.voidleech.oblivion.OblivionClient;
import com.github.voidleech.oblivion.entities.client.OblivionBoatRenderer;
import com.github.voidleech.oblivion.entities.client.OblivionModelLayers;
import com.github.voidleech.oblivion.init.OblivionBlockEntities;
import com.github.voidleech.oblivion.init.OblivionEntities;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class OblivionForgeClient {
    public static void init(IEventBus forgeEventBus, IEventBus modEventBus) {
        OblivionClient.init();
        modEventBus.addListener(OblivionForgeClient::onClientSetup);
        modEventBus.addListener(OblivionForgeClient::registerBER);
        modEventBus.addListener(OblivionForgeClient::registerModelLayers);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            EntityRenderers.m_174036_(OblivionEntities.BOAT.get(), context -> new OblivionBoatRenderer(context, false));
            EntityRenderers.m_174036_(OblivionEntities.CHEST_BOAT.get(), context -> new OblivionBoatRenderer(context, true));
            if (!OblivionClient.shaderLoaderPresent()) {
                ItemBlockRenderTypes.setRenderLayer((Fluid)Fluids.f_76195_, (RenderType)RenderType.m_110466_());
                ItemBlockRenderTypes.setRenderLayer((Fluid)Fluids.f_76194_, (RenderType)RenderType.m_110466_());
            }
        });
    }

    private static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(OblivionBlockEntities.SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer(OblivionBlockEntities.HANGING_SIGN.get(), HangingSignRenderer::new);
    }

    private static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(OblivionModelLayers.FALLBACK_BOAT_LAYER, BoatModel::m_246613_);
        event.registerLayerDefinition(OblivionModelLayers.FALLBACK_CHEST_BOAT_LAYER, ChestBoatModel::m_247175_);
    }
}

