/*
 * Decompiled with CFR 0.152.
 */
package com.github.voidleech.oblivion.entities;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public interface OblivionBoatType
extends StringRepresentable {
    public static final Map<String, OblivionBoatType> TYPES = Collections.synchronizedMap(new HashMap());

    default public void initOBT() {
        TYPES.put(this.m_7912_(), this);
    }

    default public String m_7912_() {
        return this.getName() + ":" + this.getNamespace();
    }

    public static OblivionBoatType fromSerializedName(String serializedName) {
        return TYPES.getOrDefault(serializedName, FallbackType.FALLBACK);
    }

    public String getName();

    public String getNamespace();

    public Item getBoat();

    public Item getChestBoat();

    default public boolean usesRaftModel() {
        return false;
    }

    default public boolean fireResistant() {
        return false;
    }

    public Block getPlanks();

    public static enum FallbackType implements OblivionBoatType
    {
        FALLBACK;


        @Override
        public String getName() {
            return "fallback";
        }

        @Override
        public String getNamespace() {
            return "oblivion_api";
        }

        @Override
        public Item getBoat() {
            return Items.f_42572_;
        }

        @Override
        public Item getChestBoat() {
            return Items.f_42572_;
        }

        @Override
        public Block getPlanks() {
            return Blocks.f_50145_;
        }
    }
}

