/*
 * Decompiled with CFR 0.152.
 */
package com.github.voidleech.oblivion.entities.client;

import com.github.voidleech.oblivion.entities.OblivionBoatEntity;
import com.github.voidleech.oblivion.entities.OblivionBoatType;
import com.github.voidleech.oblivion.entities.OblivionChestBoatEntity;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class OblivionBoatRenderer
extends BoatRenderer {
    private final Map<OblivionBoatType, Pair<ResourceLocation, ListModel<Boat>>> boatResources = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<? extends OblivionBoatType>, String> boatTypeClasses = Collections.synchronizedMap(new HashMap());

    public OblivionBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
        this.registerBoatResources(OblivionBoatType.FallbackType.class, "oblivion_api", pContext, pChestBoat);
        for (Map.Entry<Class<? extends OblivionBoatType>, String> entry : boatTypeClasses.entrySet()) {
            this.registerBoatResources(entry.getKey(), entry.getValue(), pContext, pChestBoat);
        }
    }

    public static <T extends OblivionBoatType> void registerBoatResources(Class<T> clazz, String modId) {
        boatTypeClasses.put(clazz, modId);
    }

    private <T extends OblivionBoatType> void registerBoatResources(Class<T> clazz, String modId, EntityRendererProvider.Context pContext, boolean pChestBoat) {
        for (OblivionBoatType type : (OblivionBoatType[])clazz.getEnumConstants()) {
            this.boatResources.put(type, (Pair<ResourceLocation, ListModel<Boat>>)Pair.of((Object)new ResourceLocation(modId, OblivionBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, type, pChestBoat)));
        }
    }

    private static String getTextureLocation(OblivionBoatType pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    protected ListModel<Boat> createBoatModel(EntityRendererProvider.Context pContext, OblivionBoatType pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? OblivionBoatRenderer.createChestBoatModelName(pType) : OblivionBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.m_174023_(modellayerlocation);
        if (pType.usesRaftModel()) {
            return pChestBoat ? new ChestRaftModel(modelpart) : new RaftModel(modelpart);
        }
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(OblivionBoatType pType) {
        return OblivionBoatRenderer.createLocation("boat/" + pType.getName(), "main", pType.getNamespace());
    }

    public static ModelLayerLocation createChestBoatModelName(OblivionBoatType pType) {
        return OblivionBoatRenderer.createLocation("chest_boat/" + pType.getName(), "main", pType.getNamespace());
    }

    private static ModelLayerLocation createLocation(String pPath, String pModel, String modId) {
        return new ModelLayerLocation(new ResourceLocation(modId, pPath), pModel);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof OblivionBoatEntity) {
            OblivionBoatEntity modBoat = (OblivionBoatEntity)boat;
            return this.boatResources.get(modBoat.getModVariant());
        }
        if (boat instanceof OblivionChestBoatEntity) {
            OblivionChestBoatEntity modChestBoatEntity = (OblivionChestBoatEntity)boat;
            return this.boatResources.get(modChestBoatEntity.getModVariant());
        }
        return null;
    }
}

