/*
 * Decompiled with CFR 0.152.
 */
package com.github.voidleech.oblivion.mixin.plugin;

import com.github.voidleech.oblivion.services.Services;

public interface Condition {
    public boolean shouldLoad();

    public static class Fabric
    implements Condition {
        private Fabric() {
        }

        @Override
        public boolean shouldLoad() {
            return Services.PLATFORM.getPlatformName().equals("Fabric");
        }
    }

    public static class Forge
    implements Condition {
        private Forge() {
        }

        @Override
        public boolean shouldLoad() {
            return Services.PLATFORM.getPlatformName().equals("Forge");
        }
    }

    public static class ModLoaded
    implements Condition {
        private final String modId;

        private ModLoaded(String modId) {
            this.modId = modId;
        }

        @Override
        public boolean shouldLoad() {
            return Services.PLATFORM.isModEarlyLoaded(this.modId);
        }
    }

    public static class And
    implements Condition {
        private final Condition condition;
        private final Condition other;

        private And(Condition condition, Condition other) {
            this.condition = condition;
            this.other = other;
        }

        @Override
        public boolean shouldLoad() {
            return this.condition.shouldLoad() && this.other.shouldLoad();
        }
    }

    public static class Not
    implements Condition {
        private final Condition condition;

        private Not(Condition condition) {
            this.condition = condition;
        }

        @Override
        public boolean shouldLoad() {
            return !this.condition.shouldLoad();
        }
    }

    public static class Builder {
        private Condition condition;

        private Builder(Condition condition) {
            this.condition = condition;
        }

        public static Builder always() {
            return new Builder(() -> true);
        }

        public static Builder modLoaded(String modId) {
            return new Builder(new ModLoaded(modId));
        }

        public static Builder onForge() {
            return new Builder(new Forge());
        }

        public static Builder onFabric() {
            return new Builder(new Fabric());
        }

        public Builder not() {
            this.condition = new Not(this.condition);
            return this;
        }

        public Builder and(Builder other) {
            this.condition = new And(this.condition, other.build());
            return this;
        }

        public Condition build() {
            return this.condition;
        }
    }
}

