package com.github.voidleech.oblivion;

import com.github.voidleech.oblivion.entities.client.OblivionBoatRenderer;
import com.github.voidleech.oblivion.entities.client.OblivionModelLayers;
import com.github.voidleech.oblivion.init.OblivionBlockEntities;
import com.github.voidleech.oblivion.init.OblivionEntities;
import com.github.voidleech.oblivion.mixin.boat.ItemBlockRenderTypesAccessor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_3612;
import net.minecraft.class_554;
import net.minecraft.class_5616;
import net.minecraft.class_7752;
import net.minecraft.class_7761;
import net.minecraft.class_837;

public class OblivionFabricClient implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        OblivionClient.init();

        EntityRendererRegistry.register(OblivionEntities.BOAT.get(), context -> new OblivionBoatRenderer(context, false));
        EntityRendererRegistry.register(OblivionEntities.CHEST_BOAT.get(), context -> new OblivionBoatRenderer(context, true));

        class_5616.method_32144(OblivionBlockEntities.SIGN.get(), class_837::new);
        class_5616.method_32144(OblivionBlockEntities.HANGING_SIGN.get(), class_7761::new);

        EntityModelLayerRegistry.registerModelLayer(OblivionModelLayers.FALLBACK_BOAT_LAYER, class_554::method_31985);
        EntityModelLayerRegistry.registerModelLayer(OblivionModelLayers.FALLBACK_CHEST_BOAT_LAYER, class_7752::method_45708);

        if (!OblivionClient.shaderLoaderPresent()) {
            ItemBlockRenderTypesAccessor.oblivion_api$TYPE_BY_FLUID().put(class_3612.field_15908, class_1921.method_23583());
            ItemBlockRenderTypesAccessor.oblivion_api$TYPE_BY_FLUID().put(class_3612.field_15907, class_1921.method_23583());
        }
    }
}
