package com.github.voidleech.oblivion.entities;

import com.github.voidleech.oblivion.Oblivion;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3542;

public interface OblivionBoatType extends class_3542{
    Map<String, OblivionBoatType> TYPES = Collections.synchronizedMap(new HashMap<>());
    default void initOBT(){
        TYPES.put(method_15434(), this);
    }

    @Override
    default String method_15434() {
        return getName() + ':' + getNamespace();
    }

    static OblivionBoatType fromSerializedName(String serializedName) {
        return TYPES.getOrDefault(serializedName, FallbackType.FALLBACK);
    }

    String getName();

    String getNamespace();
    class_1792 getBoat();
    class_1792 getChestBoat();
    default boolean usesRaftModel() {
        return false;
    }
    default boolean fireResistant() {
        return false;
    }
    class_2248 getPlanks();

    enum FallbackType implements OblivionBoatType {
        FALLBACK;

        @Override
        public String getName() {
            return "fallback";
        }

        @Override
        public String getNamespace() {
            return Oblivion.MOD_ID;
        }

        // Something for the trouble of having a fallback boat in your world
        @Override
        public class_1792 getBoat() {
            return class_1802.field_8423;
        }

        @Override
        public class_1792 getChestBoat() {
            return class_1802.field_8423;
        }

        @Override
        public class_2248 getPlanks() {
            return class_2246.field_10183;
        }
    }
}
