package com.github.voidleech.oblivion.init;

import com.github.voidleech.oblivion.Oblivion;
import com.github.voidleech.oblivion.blocks.entities.OblivionHangingSignBlockEntity;
import com.github.voidleech.oblivion.blocks.entities.OblivionSignBlockEntity;
import com.github.voidleech.oblivion.services.Services;
import org.jetbrains.annotations.ApiStatus;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_7923;

public class OblivionBlockEntities {

    public static Supplier<class_2591<OblivionSignBlockEntity>> SIGN = register("sign", () ->
            class_2591.class_2592.method_20528(OblivionSignBlockEntity::new,
                    OblivionInternal.SIGNS.toArray(new class_2248[0])
            ).method_11034(null));

    public static Supplier<class_2591<OblivionHangingSignBlockEntity>> HANGING_SIGN = register("hanging_sign", () ->
            class_2591.class_2592.method_20528(OblivionHangingSignBlockEntity::new,
                    OblivionInternal.HANGING_SIGNS.toArray(new class_2248[0])
            ).method_11034(null));

    public static <T extends class_2591<E>, E extends class_2586> Supplier<T> register(String name, Supplier<T> sup){
        return Services.PLATFORM.register(class_7923.field_41181, Oblivion.MOD_ID, name, sup);
    }

    public static void init() {
    }
}