package com.github.voidleech.oblivion.mixin.boat;

import com.github.voidleech.oblivion.entities.OblivionBoatDispenseItemBehavior;
import com.github.voidleech.oblivion.entities.OblivionBoatEntity;
import com.github.voidleech.oblivion.entities.OblivionChestBoatEntity;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2967;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_2967.class)
public abstract class BoatDispenseItemBehaviorMixin {

    @Shadow @Final private boolean isChestBoat;

    @WrapOperation(method = "execute", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean oblivion$dispenseOblivionBoat(class_1937 instance, class_1297 entity, Operation<Boolean> original,
    /* ugly locals cause Forge has a patch here */ @Local(ordinal = 1) double d1, @Local(ordinal = 2) double d2, @Local(ordinal = 3) double d3, @Local(ordinal = 4) double d4) {
        if ((Object)this instanceof OblivionBoatDispenseItemBehavior behavior) {
            var boat = isChestBoat ? new OblivionChestBoatEntity(instance, entity.field_6014, entity.field_6036, entity.field_5969) :
                    new OblivionBoatEntity(instance, entity.field_6014, entity.field_6036, entity.field_5969);
            boat.setVariant(behavior.getType());
            boat.method_36456(entity.method_36454());
            boat.method_5814(d1, d2 + d4, d3);
            return original.call(instance, boat);
        }
        return original.call(instance, entity);
    }
}
