package com.github.voidleech.oblivion.util;

import com.github.voidleech.oblivion.services.Services;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1856;
import net.minecraft.class_1935;

public class RecipeLikeProperties {
    /**
     * Adds a brewing mix.
     * @param input
     * @param ingredient
     * @param output
     */
    public static void addMix(Supplier<? extends class_1842> input, Supplier<? extends class_1792> ingredient, Supplier<? extends class_1842> output) {
        Services.PLATFORM.addMix(input, ingredient, output);
    }

    /**
     * Adds a brewing recipe. For brewing that has a non-potion as input or output.
     * Use {@link #addMix(Supplier input, Supplier ingredient, Supplier output) addMix} otherwise.
     * @param input
     * @param ingredient
     * @param output
     */
    public static void addBrewingRecipe(Supplier<? extends class_1856> input, Supplier<? extends class_1856> ingredient, Supplier<? extends class_1799> output) {
        Services.PLATFORM.addBrewingRecipe(input, ingredient, output);
    }

    /**
     * Adds an item to the composter.
     * @param item to be composted.
     * @param chance to produce a layer in the composter.
     */
    public static void addCompostable(Supplier<? extends class_1935> item, float chance) {
        Services.PLATFORM.addCompostable(item, chance);
    }

    /**
     * Adds an item as furnace fuel. Use only when getBurnTime somehow isn't available to override.
     * @param item to be used as fuel
     * @param burnTime ticks to burn. A standard furnace recipe takes 200 ticks.
     */
    public static void addFurnaceFuel(Supplier<? extends class_1935> item, int burnTime){
        Services.PLATFORM.addFurnaceFuel(item, burnTime);
    }
}
