/*
 * Decompiled with CFR 0.152.
 */
package com.github.voidleech.oblivion.entities.client;

import com.github.voidleech.oblivion.entities.OblivionBoatEntity;
import com.github.voidleech.oblivion.entities.OblivionBoatType;
import com.github.voidleech.oblivion.entities.OblivionChestBoatEntity;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1690;
import net.minecraft.class_2960;
import net.minecraft.class_4595;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7753;
import net.minecraft.class_7754;
import net.minecraft.class_881;

public class OblivionBoatRenderer
extends class_881 {
    private final Map<OblivionBoatType, Pair<class_2960, class_4595<class_1690>>> boatResources = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<? extends OblivionBoatType>, String> boatTypeClasses = Collections.synchronizedMap(new HashMap());

    public OblivionBoatRenderer(class_5617.class_5618 pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
        this.registerBoatResources(OblivionBoatType.FallbackType.class, "oblivion_api", pContext, pChestBoat);
        for (Map.Entry<Class<? extends OblivionBoatType>, String> entry : boatTypeClasses.entrySet()) {
            this.registerBoatResources(entry.getKey(), entry.getValue(), pContext, pChestBoat);
        }
    }

    public static <T extends OblivionBoatType> void registerBoatResources(Class<T> clazz, String modId) {
        boatTypeClasses.put(clazz, modId);
    }

    private <T extends OblivionBoatType> void registerBoatResources(Class<T> clazz, String modId, class_5617.class_5618 pContext, boolean pChestBoat) {
        for (OblivionBoatType type : (OblivionBoatType[])clazz.getEnumConstants()) {
            this.boatResources.put(type, (Pair<class_2960, class_4595<class_1690>>)Pair.of((Object)new class_2960(modId, OblivionBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, type, pChestBoat)));
        }
    }

    private static String getTextureLocation(OblivionBoatType pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    protected class_4595<class_1690> createBoatModel(class_5617.class_5618 pContext, OblivionBoatType pType, boolean pChestBoat) {
        class_5601 modellayerlocation = pChestBoat ? OblivionBoatRenderer.createChestBoatModelName(pType) : OblivionBoatRenderer.createBoatModelName(pType);
        class_630 modelpart = pContext.method_32167(modellayerlocation);
        if (pType.usesRaftModel()) {
            return pChestBoat ? new class_7753(modelpart) : new class_7754(modelpart);
        }
        return pChestBoat ? new class_7752(modelpart) : new class_554(modelpart);
    }

    public static class_5601 createBoatModelName(OblivionBoatType pType) {
        return OblivionBoatRenderer.createLocation("boat/" + pType.getName(), "main", pType.getNamespace());
    }

    public static class_5601 createChestBoatModelName(OblivionBoatType pType) {
        return OblivionBoatRenderer.createLocation("chest_boat/" + pType.getName(), "main", pType.getNamespace());
    }

    private static class_5601 createLocation(String pPath, String pModel, String modId) {
        return new class_5601(new class_2960(modId, pPath), pModel);
    }

    public Pair<class_2960, class_4595<class_1690>> getModelWithLocation(class_1690 boat) {
        if (boat instanceof OblivionBoatEntity) {
            OblivionBoatEntity modBoat = (OblivionBoatEntity)boat;
            return this.boatResources.get(modBoat.getModVariant());
        }
        if (boat instanceof OblivionChestBoatEntity) {
            OblivionChestBoatEntity modChestBoatEntity = (OblivionChestBoatEntity)boat;
            return this.boatResources.get(modChestBoatEntity.getModVariant());
        }
        return null;
    }
}

