package com.github.voidleech.oblivion.services;

import com.github.voidleech.oblivion.mixin.accessor.ComposterBlockInvoker;
import com.github.voidleech.oblivion.services.services.IPlatformHelper;
import com.github.voidleech.oblivion.util.Registration;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import io.github.fabricators_of_create.porting_lib.brewing.BrewingRecipeRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ResourceManagerHelperImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1845;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

import java.nio.file.Path;
import java.util.function.Supplier;

public class FabricPlatformHelper implements IPlatformHelper {

    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {

        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isModEarlyLoaded(String modId) {
        return isModLoaded(modId);
    }

    @Override
    public Path getResourcePath(String modId, String resource) {
        return FabricLoader.getInstance().getModContainer(modId).get().getPath(resource);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public <I, T extends I> Supplier<T> register(class_2378<I> registry, String modId, String name, Supplier<T> sup) {
        T object = class_2378.method_10230(registry, new class_2960(modId, name), sup.get());
        return () -> object;
    }

    @Override
    public void addMix(Supplier<? extends class_1842> input, Supplier<? extends class_1792> ingredient, Supplier<? extends class_1842> output) {
        class_1845.method_8074(input.get(), ingredient.get(), output.get());
    }

    @Override
    public void addBrewingRecipe(Supplier<? extends class_1856> input, Supplier<? extends class_1856> ingredient, Supplier<? extends class_1799> output) {
        BrewingRecipeRegistry.addRecipe(input.get(), ingredient.get(), output.get());
    }

    @Override
    public void addCompostable(Supplier<? extends class_1935> item, float chance) {
        ComposterBlockInvoker.oblivion$add(chance, item.get());
    }

    @Override
    public void addFurnaceFuel(Supplier<? extends class_1935> item, int burnTime) {
        FuelRegistry.INSTANCE.add(item.get(), burnTime);
    }

    @Override
    public void registerConfig(ForgeConfigSpec spec, ModConfig.Type type, String modId) {
        ForgeConfigRegistry.INSTANCE.register(modId, type, spec);
    }

    @Override
    public void addPack(Registration.PackData pack, String modId) {
        ResourceManagerHelperImpl.registerBuiltinResourcePack(new class_2960(modId, pack.name() + (pack.type() == class_3264.field_14188 ? "_r" : "_d")),
                "packs/" + ((pack.type() == class_3264.field_14188 ? "resource/" : "data/") + pack.name()),
                FabricLoader.getInstance().getModContainer(modId).get(), pack.display(),
                pack.required() ? ResourcePackActivationType.ALWAYS_ENABLED :
                        pack.enabledByDefault() ? ResourcePackActivationType.DEFAULT_ENABLED : ResourcePackActivationType.NORMAL);
    }
}
