/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.nullved.pmweatherapi.client.render.IRadarOverlay;
import net.nullved.pmweatherapi.client.render.RadarOverlays;
import net.nullved.pmweatherapi.client.render.RenderData;
import net.nullved.pmweatherapi.config.PMWClientConfig;
import net.nullved.pmweatherapi.radar.RadarMode;

@OnlyIn(value=Dist.CLIENT)
public class IDOverlay
implements IRadarOverlay {
    public static final IRadarOverlay INSTANCE = new IDOverlay();

    @Override
    public void render(boolean canRender, RenderData renderData, BufferBuilder bufferBuilder, Object ... args) {
        float lineHeight;
        if (!PMWClientConfig.showRadarModeId) {
            return;
        }
        if (!Minecraft.getInstance().player.isCrouching()) {
            return;
        }
        RadarMode mode = this.getRadarMode(renderData);
        PoseStack poseStack = renderData.poseStack();
        PMWClientConfig.RadarModeIDSide side = PMWClientConfig.radarModeIDSide;
        float scale = renderData.sizeRenderDiameter() / 3.0f;
        poseStack.pushPose();
        poseStack.translate((float)side.x * scale - 0.5f * (scale - 1.0f), 1.055f, (float)side.z * scale - 0.5f * (scale - 1.0f));
        poseStack.mulPose(Axis.YN.rotationDegrees((float)side.rotation));
        poseStack.scale(0.01f, 0.01f, 0.01f);
        this.renderText((Component)Component.literal((String)mode.getId().toString()), renderData, poseStack);
        float offset = lineHeight = 8.0f;
        for (Supplier<? extends IRadarOverlay> overlay : RadarOverlays.getOverlays()) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, offset);
            poseStack.scale(0.6f, 0.6f, 0.6f);
            this.renderText((Component)Component.literal((String)overlay.get().getID().toString()).withColor(0x888888), renderData, poseStack);
            poseStack.popPose();
            offset += lineHeight * 0.6f;
        }
        poseStack.popPose();
    }

    @Override
    public String getModID() {
        return "pmweatherapi";
    }

    @Override
    public String getIDPath() {
        return "id";
    }
}

