/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.example;

import com.mojang.blaze3d.vertex.BufferBuilder;
import dev.protomanly.pmweather.config.ClientConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.nullved.pmweatherapi.client.render.IRadarOverlay;
import net.nullved.pmweatherapi.client.render.RenderData;
import net.nullved.pmweatherapi.radar.NearbyRadars;
import net.nullved.pmweatherapi.radar.RadarMode;
import net.nullved.pmweatherapi.storm.NearbyStorms;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ExampleOverlay
implements IRadarOverlay {
    public static final ExampleOverlay INSTANCE = new ExampleOverlay();

    @Override
    public void render(boolean canRender, RenderData renderData, BufferBuilder bufferBuilder, Object ... args) {
        if (!canRender) {
            return;
        }
        BlockEntity blockEntity = renderData.blockEntity();
        BlockPos pos = blockEntity.getBlockPos();
        RadarMode mode = this.getRadarMode(renderData);
        if (mode == RadarMode.REFLECTIVITY) {
            NearbyRadars.client().forRadarNearBlock(pos, 2048.0, p -> ExampleOverlay.renderMarker(bufferBuilder, p.offset(-pos.getX(), -pos.getY(), -pos.getZ()).getCenter()));
        } else if (mode == RadarMode.VELOCITY) {
            NearbyStorms.client().forStormNearBlock(pos, 2048.0, s -> ExampleOverlay.renderMarker(bufferBuilder, s.position.add((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()))));
        }
    }

    @Override
    public String getModID() {
        return "pmweatherapi_test";
    }

    private static void renderMarker(BufferBuilder bufferBuilder, Vec3 relative) {
        float resolution = ClientConfig.radarResolution;
        Vector3f radarPos = relative.add(0.5, 0.5, 0.5).toVector3f().mul(3.0f / (2.0f * resolution)).div(2048.0f, 0.0f, 2048.0f).div(1.0f / resolution, 0.0f, 1.0f / resolution);
        Vector3f topLeft = new Vector3f(-1.0f, 0.0f, -1.0f).mul(0.015f).add(radarPos.x, 0.005f, radarPos.z);
        Vector3f bottomLeft = new Vector3f(-1.0f, 0.0f, 1.0f).mul(0.015f).add(radarPos.x, 0.005f, radarPos.z);
        Vector3f bottomRight = new Vector3f(1.0f, 0.0f, 1.0f).mul(0.015f).add(radarPos.x, 0.005f, radarPos.z);
        Vector3f topRight = new Vector3f(1.0f, 0.0f, -1.0f).mul(0.015f).add(radarPos.x, 0.005f, radarPos.z);
        int color = -5592406;
        bufferBuilder.addVertex(topLeft).setColor(color).addVertex(bottomLeft).setColor(color).addVertex(bottomRight).setColor(color).addVertex(topRight).setColor(color);
    }
}

