/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.client.data;

import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.storage.IStorage;
import net.nullved.pmweatherapi.storage.data.IStorageData;
import net.nullved.pmweatherapi.storage.data.StorageData;

public interface IClientStorage<D extends IStorageData>
extends IStorage<D> {
    public ClientLevel getLevel();

    default public void syncAll(CompoundTag tag) {
        this.clean();
        this.syncAdd(tag);
    }

    default public void syncAdd(CompoundTag tag) {
        int version = tag.getInt("version");
        if (tag.contains("list") && tag.getBoolean("list")) {
            ListTag list = tag.getList("data", 10);
            this.add(list.stream().map(t -> {
                try {
                    return StorageData.deserializeFromNBT((CompoundTag)t, version);
                }
                catch (ClassCastException e) {
                    PMWeatherAPI.LOGGER.info("Invalid data entry in NBT: {}", (Object)e.getMessage());
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet()));
        } else {
            try {
                this.add(StorageData.deserializeFromNBT(tag.getCompound("data"), version));
            }
            catch (ClassCastException e) {
                PMWeatherAPI.LOGGER.info("Invalid data entry in NBT: {}", (Object)e.getMessage());
            }
        }
    }

    default public void syncRemove(CompoundTag tag) {
        int version = tag.getInt("version");
        if (!tag.contains("format")) {
            if (tag.contains("list") && tag.getBoolean("list")) {
                ListTag list = tag.getList("data", 10);
                this.removeByData(list.stream().map(t -> {
                    try {
                        return StorageData.deserializeFromNBT((CompoundTag)t, version);
                    }
                    catch (ClassCastException e) {
                        PMWeatherAPI.LOGGER.info("Invalid data entry in NBT: {}", (Object)e.getMessage());
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toSet()));
            } else {
                try {
                    this.remove(StorageData.deserializeFromNBT(tag.getCompound("data"), version));
                }
                catch (ClassCastException e) {
                    PMWeatherAPI.LOGGER.info("Invalid data entry in NBT: {}", (Object)e.getMessage());
                }
            }
        } else if (tag.getString("format").equals("blockpos")) {
            if (tag.contains("list") && tag.getBoolean("list")) {
                ListTag list = tag.getList("data", 11);
                this.removeByPos(list.stream().map(t -> {
                    if (t instanceof IntArrayTag) {
                        IntArrayTag iat = (IntArrayTag)t;
                        return new BlockPos(iat.get(0).getAsInt(), iat.get(1).getAsInt(), iat.get(2).getAsInt());
                    }
                    return null;
                }).collect(Collectors.toSet()));
            } else {
                this.remove((BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"data").orElseThrow());
            }
        } else {
            PMWeatherAPI.LOGGER.info("Invalid data format for packet: '{}'!", (Object)tag.getString("format"));
        }
    }
}

