/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.client.event;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.client.data.PMWClientStorages;

@EventBusSubscriber(modid="pmweatherapi", value={Dist.CLIENT})
public class PMWClientEvents {
    @SubscribeEvent
    public static void onLevelLoadEvent(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (level.isClientSide() && level instanceof ClientLevel) {
            ClientLevel clevel = (ClientLevel)level;
            PMWeatherAPI.LOGGER.info("Loaded client storages for dimension {}", (Object)clevel.dimension().location());
            PMWClientStorages.loadDimension(clevel);
        }
    }

    @SubscribeEvent
    public static void onLevelUnloadEvent(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        if (level.isClientSide() && level instanceof ClientLevel) {
            ClientLevel clevel = (ClientLevel)level;
            PMWeatherAPI.LOGGER.info("Unloaded client storages for dimension {}", (Object)clevel.dimension().location());
        }
    }
}

