/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.nullved.pmweatherapi.client.render.RenderData;
import net.nullved.pmweatherapi.data.PMWExtras;
import net.nullved.pmweatherapi.radar.RadarMode;

public interface IRadarOverlay {
    public void render(boolean var1, RenderData var2, BufferBuilder var3, Object ... var4);

    default public RadarMode getRadarMode(RenderData renderData) {
        return (RadarMode)renderData.blockEntity().getBlockState().getValue((Property)PMWExtras.RADAR_MODE);
    }

    default public void renderTexture(ResourceLocation texture, RenderData renderData, PoseStack poseStack, int color) {
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer consumer = renderData.multiBufferSource().getBuffer(RenderType.entityCutout((ResourceLocation)texture));
        consumer.addVertex(pose, -0.5f, -0.5f, 0.0f).setColor(color).setUv(0.0f, 0.0f).setOverlay(renderData.combinedOverlayIn()).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, 0.5f, -0.5f, 0.0f).setColor(color).setUv(1.0f, 0.0f).setOverlay(renderData.combinedOverlayIn()).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, 0.5f, 0.5f, 0.0f).setColor(color).setUv(1.0f, 1.0f).setOverlay(renderData.combinedOverlayIn()).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, -0.5f, 0.5f, 0.0f).setColor(color).setUv(0.0f, 1.0f).setOverlay(renderData.combinedOverlayIn()).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
    }

    default public void renderTexture(ResourceLocation texture, RenderData renderData, PoseStack poseStack) {
        this.renderTexture(texture, renderData, poseStack, -1);
    }

    default public void renderTexture(ResourceLocation texture, RenderData renderData, int color) {
        this.renderTexture(texture, renderData, renderData.poseStack(), color);
    }

    default public void renderTexture(ResourceLocation texture, RenderData renderData) {
        this.renderTexture(texture, renderData, renderData.poseStack(), -1);
    }

    default public void renderText(Component component, RenderData renderData, PoseStack poseStack) {
        Font font = Minecraft.getInstance().font;
        font.drawInBatch(component, 0.0f, 0.0f, 0xFFFFFF, false, poseStack.last().pose(), renderData.multiBufferSource(), Font.DisplayMode.NORMAL, 0xFFFFFF, 0xFFFFFF);
    }

    default public void renderText(Component component, RenderData renderData) {
        this.renderText(component, renderData, renderData.poseStack());
    }

    public String getModID();

    default public String getIDPath() {
        return this.getClass().getSimpleName().replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
    }

    default public ResourceLocation getID() {
        return ResourceLocation.fromNamespaceAndPath((String)this.getModID(), (String)this.getIDPath());
    }
}

