/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.nullved.pmweatherapi.network.S2CMetarPacket;
import net.nullved.pmweatherapi.network.S2CRadarPacket;
import net.nullved.pmweatherapi.network.S2CStoragePacket;
import net.nullved.pmweatherapi.network.S2CWSRPacket;

public class PMWNetworking {
    public static void register(Object ... args) {
        PMWNetworking.registerClientboundPacket(S2CRadarPacket.TYPE, S2CRadarPacket.STREAM_CODEC, S2CStoragePacket::handle, args);
        PMWNetworking.registerClientboundPacket(S2CMetarPacket.TYPE, S2CMetarPacket.STREAM_CODEC, S2CStoragePacket::handle, args);
        PMWNetworking.registerClientboundPacket(S2CWSRPacket.TYPE, S2CWSRPacket.STREAM_CODEC, S2CStoragePacket::handle, args);
    }

    public static <T extends CustomPacketPayload> void registerServerboundPacket(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, BiConsumer<T, Player> handler, Object ... args) {
        PayloadRegistrar registrar = (PayloadRegistrar)args[0];
        IPayloadHandler serverHandler = (pkt, ctx) -> ctx.enqueueWork(() -> handler.accept(pkt, ctx.player()));
        registrar.playToServer(type, codec, serverHandler);
    }

    public static <T extends CustomPacketPayload> void registerClientboundPacket(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, BiConsumer<T, Player> handler, Object ... args) {
        PayloadRegistrar registrar = (PayloadRegistrar)args[0];
        IPayloadHandler clientHandler = (pkt, ctx) -> ctx.enqueueWork(() -> handler.accept(pkt, ctx.player()));
        registrar.playToClient(type, codec, clientHandler);
    }

    public static void serverSendStorageToAll(CompoundTag tag, Function<CompoundTag, S2CStoragePacket<?>> pkt) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)pkt.apply(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void serverSendStorageToPlayer(CompoundTag tag, Function<CompoundTag, S2CStoragePacket<?>> pkt, Player player) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)pkt.apply(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

