/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.radar;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.nullved.pmweatherapi.client.data.PMWClientStorages;
import net.nullved.pmweatherapi.data.PMWStorages;
import net.nullved.pmweatherapi.radar.storage.RadarStorage;
import net.nullved.pmweatherapi.radar.storage.RadarStorageData;

public class NearbyRadars {
    private static final HashMap<ResourceKey<Level>, NearbyRadars> DIMENSION_MAP = new HashMap();
    private final RadarStorage storage;

    private NearbyRadars(RadarStorage storage) {
        this.storage = storage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static NearbyRadars client() {
        return new NearbyRadars(PMWClientStorages.radars().get());
    }

    public static NearbyRadars get(ResourceKey<Level> dim) {
        return DIMENSION_MAP.computeIfAbsent(dim, d -> new NearbyRadars(PMWStorages.radars().get((ResourceKey<Level>)d)));
    }

    public static NearbyRadars get(Level level) {
        return NearbyRadars.get((ResourceKey<Level>)level.dimension());
    }

    public Set<BlockPos> radarsNearBlock(BlockPos pos, double radius) {
        HashSet<BlockPos> radarList = new HashSet<BlockPos>();
        for (RadarStorageData radar : this.storage.getAll()) {
            if (!(Math.abs(radar.getPos().distToCenterSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) <= radius * radius)) continue;
            radarList.add(radar.getPos());
        }
        radarList.remove(pos);
        return radarList;
    }

    public Set<BlockPos> radarsNearChunk(ChunkPos pos, double radius) {
        HashSet<BlockPos> radarList = new HashSet<BlockPos>();
        for (RadarStorageData radar : this.storage.getAll()) {
            if (!(Math.abs(radar.getPos().distToCenterSqr((double)pos.getMiddleBlockX(), (double)radar.getPos().getY(), (double)pos.getMiddleBlockZ())) <= radius * radius)) continue;
            radarList.add(radar.getPos());
        }
        return radarList;
    }

    public Set<BlockPos> radarsNearPlayer(Player player, double radius) {
        HashSet<BlockPos> radarList = new HashSet<BlockPos>();
        for (RadarStorageData radar : this.storage.getAll()) {
            if (!(Math.abs(radar.getPos().distToCenterSqr(player.getX(), player.getY(), player.getZ())) <= radius * radius)) continue;
            radarList.add(radar.getPos());
        }
        return radarList;
    }

    public void forRadarNearBlock(BlockPos block, double radius, Consumer<BlockPos> consumer) {
        Set<BlockPos> radars = this.radarsNearBlock(block, radius);
        for (BlockPos radar : radars) {
            consumer.accept(radar);
        }
    }

    public void forRadarNearChunk(ChunkPos chunk, double radius, Consumer<BlockPos> consumer) {
        Set<BlockPos> radars = this.radarsNearChunk(chunk, radius);
        for (BlockPos radar : radars) {
            consumer.accept(radar);
        }
    }

    public void forRadarNearPlayer(Player player, double radius, Consumer<BlockPos> consumer) {
        Set<BlockPos> radars = this.radarsNearPlayer(player, radius);
        for (BlockPos radar : radars) {
            consumer.accept(radar);
        }
    }
}

