/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.radar;

import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.block.entity.RadarBlockEntity;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.biome.Biome;
import net.nullved.pmweatherapi.client.render.PixelRenderData;
import net.nullved.pmweatherapi.util.ColorMap;
import net.nullved.pmweatherapi.util.ColorMaps;
import net.nullved.pmweatherapi.util.StringValue;
import org.jetbrains.annotations.NotNull;

public class RadarMode
implements StringRepresentable,
Comparable<RadarMode> {
    private static final LinkedHashMap<ResourceLocation, RadarMode> MODES = new LinkedHashMap();
    private static boolean disableBaseRendering = false;
    public static final RadarMode NULL = new RadarMode(ResourceLocation.parse((String)"null"), prd -> {
        if (prd.x() > 0 && prd.z() > 0 || prd.x() <= 0 && prd.z() <= 0) {
            return new Color(1.0f, 0.0f, 1.0f);
        }
        return Color.BLACK;
    }, new Color(0, 0, 0, 0));
    public static final RadarMode REFLECTIVITY = RadarMode.create(PMWeather.getPath((String)"reflectivity"), prd -> {
        Holder biome = ((RadarBlockEntity)prd.renderData().blockEntity()).getNearestBiome(new BlockPos((int)prd.worldPos().x, (int)prd.worldPos().y, (int)prd.worldPos().z));
        if (biome != null) {
            return ColorMaps.REFLECTIVITY.getWithBiome(prd.rdbz(), (Holder<Biome>)biome, prd.worldPos());
        }
        return ColorMaps.REFLECTIVITY.get(prd.rdbz());
    });
    public static final RadarMode VELOCITY = RadarMode.create(PMWeather.getPath((String)"velocity"), prd -> {
        Color velCol = prd.velocity() >= 0.0f ? ColorMaps.POSITIVE_VELOCITY.get(prd.velocity() / 1.75f) : ColorMaps.NEGATIVE_VELOCITY.get(-prd.velocity() / 1.75f);
        return ColorMap.lerp(Mth.clamp((float)(Math.max(prd.rdbz(), (Mth.abs((float)(prd.velocity() / 1.75f)) - 18.0f) / 0.65f) / 12.0f), (float)0.0f, (float)1.0f), Color.BLACK, velCol);
    });
    public static final RadarMode IR = RadarMode.create(PMWeather.getPath((String)"ir"), prd -> {
        float rdbz = prd.rdbz();
        float ir = rdbz * 10.0f;
        if (rdbz > 10.0f) {
            ir = 100.0f + (rdbz - 10.0f) * 2.5f;
        }
        if (rdbz > 50.0f) {
            ir += (rdbz - 50.0f) * 5.0f;
        }
        return ColorMaps.IR.get(ir);
    });
    private final ResourceLocation id;
    private final Function<PixelRenderData, Color> colorFunction;
    private final Color dotColor;

    private RadarMode(ResourceLocation id, Function<PixelRenderData, Color> colorFunction, Color dotColor) {
        this.id = id;
        this.colorFunction = colorFunction;
        this.dotColor = dotColor;
    }

    public static void disableBaseRendering(boolean disable) {
        disableBaseRendering = disable;
    }

    public static boolean isBaseRenderingDisabled() {
        return disableBaseRendering;
    }

    public static RadarMode create(ResourceLocation id, Function<PixelRenderData, Color> colorFunction, Color renderDotColor) {
        return MODES.computeIfAbsent(id, nm -> new RadarMode(id, colorFunction, renderDotColor));
    }

    public static RadarMode create(ResourceLocation id, Function<PixelRenderData, Color> colorFunction) {
        return RadarMode.create(id, colorFunction, Color.RED);
    }

    public static Collection<RadarMode> values() {
        return MODES.values();
    }

    public static RadarMode get(ResourceLocation id) {
        return MODES.getOrDefault(id, NULL);
    }

    public static RadarMode get(String id) {
        RadarMode radarMode = MODES.get(ResourceLocation.tryParse((String)id.replaceFirst("_", ":")));
        if (radarMode != null) {
            return radarMode;
        }
        for (RadarMode mode : MODES.values()) {
            if (!id.equals(mode.id.toString().replace(":", "_"))) continue;
            return mode;
        }
        return NULL;
    }

    public RadarMode cycle() {
        Object[] values = (RadarMode[])MODES.values().toArray(RadarMode[]::new);
        int idx = Arrays.binarySearch(values, this);
        return values[(idx + 1) % values.length];
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Color getDotColor() {
        return this.dotColor;
    }

    public Color getColorForPixel(PixelRenderData pixelRenderData) {
        return this.colorFunction.apply(pixelRenderData);
    }

    public StringValue stringValue() {
        return new StringValue(this.getSerializedName());
    }

    public String getSerializedName() {
        return this.id.toString().replace(":", "_");
    }

    @Override
    public int compareTo(@NotNull RadarMode o) {
        ArrayList<ResourceLocation> modeKeys = new ArrayList<ResourceLocation>(MODES.keySet());
        return Integer.compare(modeKeys.indexOf(this.id), modeKeys.indexOf(o.id));
    }
}

