/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.radar.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.radar.RadarMode;
import net.nullved.pmweatherapi.storage.data.StorageData;

public class RadarStorageData
extends StorageData {
    public static final ResourceLocation ID = PMWeatherAPI.rl("radar");
    private RadarMode radarMode;

    public RadarStorageData(BlockPos pos, RadarMode radarMode) {
        super(pos);
        this.radarMode = radarMode;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag serializeToNBT() {
        CompoundTag tag = super.serializeToNBT();
        tag.putString("radar_mode", this.radarMode.getSerializedName());
        return tag;
    }

    public static RadarStorageData deserializeFromNBT(CompoundTag tag, int version) {
        BlockPos bp = RadarStorageData.deserializeBlockPos(tag);
        if (bp != null) {
            RadarMode mode = RadarMode.get(tag.getString("radar_mode"));
            return new RadarStorageData(bp, mode);
        }
        return new RadarStorageData((BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"").orElseThrow(() -> new IllegalArgumentException("Could not read BlockPos in RadarStorageData!")), RadarMode.get(tag.getString("radar_mode")));
    }
}

